/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade;

import lombok.Data;

import java.io.Serializable;

/**
 * 微信营销详情
 *
 * @author
 * @version FuiouReservedPromotionDetailResponse.java, v 0.1 2023-09-16 17:08
 */
@Data
public class FuiouReservedPromotionDetailResponse implements Serializable {

    private static final long serialVersionUID = 7538168845375377353L;
    /**
     * 券 id
     */
    private String promotionId;

    /**
     * 优惠名称
     */
    private String name;

    /**
     * 全范围； GLOBAL- 全场代金券 SINGLE- 单品优惠  DISCOUNT-折扣券
     */
    private String scope;

    /**
     * 优惠类型；COUPON-充值型代金券 DISCOUNT-免充值优惠券
     */
    private String type;

    /**
     * 优惠总额；单位分
     */
    private String amount;

    /**
     * 活动 id
     */
    private String activityId;

    /**
     * 微信出资金额；单位分
     */
    private String wxpayContribute;

    /**
     * 商户出资金额；单位分
     */
    private String merchantContribute;

    /**
     * 其他出资金额；单位分
     */
    private String otherContribute;
}