/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.client.base.IFuiouBankPayApiDefinition;
import com.fshows.fuiou.response.base.FuiouBankPayBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 银行卡支付业务请求参数的基础父类
 *
 * @author zhaoxumin
 * @version FuiouBizRequest.java, v 0.1 2023-10-16 10:11
 */
@Data
public class FuiouBankPayBizRequest<T extends FuiouBankPayBizResponse, E extends IFuiouBankPayApiDefinition> implements Serializable {

    private static final long serialVersionUID = -5679474626910520640L;
    /**
     * 外部订单号
     */
    @NotBlank
    @JSONField(name = "in_order_no")
    private String inOrderNo;

    /**
     * 合作方机构号
     */
    @JSONField(name = "relate_ins_cd")
    private String relateInsCd;

    /**
     * MD5(inOrderNo + 富友分配给合作方接口密钥)  utf-8
     */
    private String signature;
}