/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.order;

import com.fshows.fuiou.enums.FuiouApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.trade.order.FuiouBankCardPayOrderQueryResponse;
import com.fshows.fuiou.response.trade.order.FuiouOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouBankCardPayOrderQueryRequest.java, v 0.1 2023-10-12 19:54:02
 */
@Data
public class FuiouBankCardPayOrderQueryRequest extends FuiouBizRequest<FuiouBankCardPayOrderQueryResponse, FuiouApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -8171213238426052613L;

    /**
     * 外部订单号
     *
     * (必填)
     */
    @NotBlank
    private String inOrderNo;

    /**
     * 交易清算日期，查隔天交易时必传日期格式（yyyyMMdd）
     *
     * (选填)
     */
    private String kbpsSrcSettleDt;

    /**
     * 合作方机构号
     *
     * (必填)
     */
    @NotBlank
    private String relateInsCd;

    /**
     * 签名，MD5(inOrderNo + 富友分配给合作方接口密钥)  utf-8
     *
     * (必填)
     */
    @NotBlank
    private String signature;
}