package com.fshows.fuiou.enums.settlement;

import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.settlement.FuiouQuerySettlementListRequest;
import com.fshows.fuiou.response.settlement.FuiouQuerySettlementListResponse;

/**
 * 富友结算相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum FuiouSettlementApiDefinitionEnum implements IFuiouApiDefinition {
    QUERY_SETTLEMENT_LIST(
            "资金划拨查询，查询商户在某段时间内自动结算的笔数及金额信息",
            "/queryChnlPayAmt",
            FuiouConstant.SETTLEMENT_API_VERSION_V1,
            FuiouQuerySettlementListRequest.class,
            FuiouQuerySettlementListResponse.class
    )
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    FuiouSettlementApiDefinitionEnum(String name,
                                     String apiSubURI,
                                     String version,
                                     Class requestClass,
                                     Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}