/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.enums.merchant;

import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.request.merchant.FuiouAgreementCreateRequest;
import com.fshows.fuiou.request.merchant.FuiouAgreementSignRequest;
import com.fshows.fuiou.request.merchant.FuiouAuditQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouCallbackAddressRequest;
import com.fshows.fuiou.request.merchant.FuiouCommitFinishRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantIncomeRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouPicUploadRequest;
import com.fshows.fuiou.request.merchant.FuiouRateUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouSettleUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouSubMerchantQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouUnionpayApplyRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.response.merchant.FuiouAgreementCreateResponse;
import com.fshows.fuiou.response.merchant.FuiouAgreementSignResponse;
import com.fshows.fuiou.response.merchant.FuiouAuditQueryResponse;
import com.fshows.fuiou.response.merchant.FuiouCallbackAddressResponse;
import com.fshows.fuiou.response.merchant.FuiouCommitFinishResponse;
import com.fshows.fuiou.response.merchant.FuiouMerchantIncomeResponse;
import com.fshows.fuiou.response.merchant.FuiouMerchantQueryResponse;
import com.fshows.fuiou.response.merchant.FuiouMerchantUpdateResponse;
import com.fshows.fuiou.response.merchant.FuiouPicUploadResponse;
import com.fshows.fuiou.response.merchant.FuiouRateUploadResponse;
import com.fshows.fuiou.response.merchant.FuiouSettleUploadResponse;
import com.fshows.fuiou.response.merchant.FuiouSubMerchantQueryResponse;
import com.fshows.fuiou.response.merchant.FuiouUnionpayApplyResponse;

/**
 * @author zhubo
 * @version FuiouMerchantApiDefinitionEnum.java, v 0.1 2023-09-11 11:38 zhubo
 */
public enum FuiouMerchantApiDefinitionEnum implements IFuiouApiDefinition {
    MERCHANT_INCOME(
            "商户信息登记接口",
            "/wxMchntMng.fuiou?action=wxMchntAdd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantIncomeRequest.class,
            FuiouMerchantIncomeResponse.class

    ),
    MECHANT_UPDATE(
            "商户信息更新接口",
            "/wxMchntMng.fuiou?action=wxMchntUpd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantUpdateRequest.class,
            FuiouMerchantUpdateResponse.class
    ),
    SETTLE_UPDATE(
            "入账信息变更接口v2",
            "/wxMchntUpd.fuiou?action=mchntAcntUpdV2",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouSettleUpdateRequest.class,
            FuiouSettleUploadResponse.class
    ),
    PICTURE_UPLOAD(
            "统一图片上传接口",
            "/upload.fuiou?action=uploadImg",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouPicUploadRequest.class,
            FuiouPicUploadResponse.class
    ),
    RATE_UPDATE(
            "扣率信息变更(收单常规)",
            "/wxMchntUpd.fuiou?action=mchntCalcUpdSD",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouRateUpdateRequest.class,
            FuiouRateUploadResponse.class
    ),
    WECHAT_CONFIG(
            "微信参数配置接口",
            "/wxMchntMng.fuiou?action=xyWechatConfigSet",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouPicUploadRequest.class,
            FuiouPicUploadResponse.class
    ),
    AGREEMENT_CREATE(
            "电子协议生成",
            "/wxMchntMng.fuiou?action=elecContractGenerate",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouAgreementCreateRequest.class,
            FuiouAgreementCreateResponse.class
    ),
    AGREEMENT_SIGN(
            "电子协议签署",
            "/wxMchntMng.fuiou?action=elecContractSign",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouAgreementSignRequest.class,
            FuiouAgreementSignResponse.class
    ),
    COMMIT_FINISH(
            "附件提交完成接口",
            "/wxMchntMng.fuiou?action=attachConfirm",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouCommitFinishRequest.class,
            FuiouCommitFinishResponse.class
    ),
    MERCHANT_QUERY(
            "商户信息查询接口",
            "/wxMchntMng.fuiou?action=getMchntInfAndConfig",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantQueryRequest.class,
            FuiouMerchantQueryResponse.class
    ),
    AUDIT_QUERY(
            "业务审核状态查询接口",
            "/wxMchntMng.fuiou?action=mchntQueryTZ",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouAuditQueryRequest.class,
            FuiouAuditQueryResponse.class
    ),
    UNIONPAY_APPLY(
            "银联二维码业务申请开通接口",
            "/wxMchntMng.fuiou?action=mchntOpenUpayQr",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouUnionpayApplyRequest.class,
            FuiouUnionpayApplyResponse.class
    ),
    SUB_MERCHANT_QUERY(
            "商户渠道子商户号查询接口",
            "/wxMchntMng.fuiou?action=chnlSubMchIdQuery",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouSubMerchantQueryRequest.class,
            FuiouSubMerchantQueryResponse.class
    ),
    CALLBACK_ADDRESS(
            "回调地址设置接口",
            "/notifyConfig.fuiou?action=notifyConfig",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouCallbackAddressRequest.class,
            FuiouCallbackAddressResponse.class
    ),

    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    FuiouMerchantApiDefinitionEnum(String name, String apiSubURI, String version, Class requestClass, Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public <T extends FuiouBizRequest> Class<T> getRequestClass() {
        return requestClass;
    }

    @Override
    public <T extends FuiouBizResponse> Class<T> getResponseClass() {
        return responseClass;
    }
}