package com.fshows.fuiou.enums;

import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.trade.order.FuiouBankCardPayOrderQueryRequest;
import com.fshows.fuiou.request.trade.order.FuiouHisOrderQueryRequest;
import com.fshows.fuiou.request.trade.order.FuiouOrderCloseRequest;
import com.fshows.fuiou.request.trade.order.FuiouOrderQueryRequest;
import com.fshows.fuiou.request.trade.order.FuiouOrderRevokedRequest;
import com.fshows.fuiou.request.trade.order.FuiouRefundQueryRequest;
import com.fshows.fuiou.request.trade.order.FuiouRefundRequest;
import com.fshows.fuiou.request.trade.pay.FuiouJsApiPayRequest;
import com.fshows.fuiou.request.trade.pay.FuiouPreOrderRequest;
import com.fshows.fuiou.request.trade.pay.FuiouScanCardRequest;
import com.fshows.fuiou.request.trade.pay.FuiouWxAndUnionUserIdRequest;
import com.fshows.fuiou.response.trade.order.FuiouBankCardPayOrderQueryResponse;
import com.fshows.fuiou.response.trade.order.FuiouOrderCloseResponse;
import com.fshows.fuiou.response.trade.order.FuiouOrderQueryResponse;
import com.fshows.fuiou.response.trade.order.FuiouOrderRevokedResponse;
import com.fshows.fuiou.response.trade.order.FuiouRefundQueryResponse;
import com.fshows.fuiou.response.trade.order.FuiouRefundResponse;
import com.fshows.fuiou.response.trade.pay.FuiouJsApiPayResponse;
import com.fshows.fuiou.response.trade.pay.FuiouPreOrderResponse;
import com.fshows.fuiou.response.trade.pay.FuiouScanCardResponse;
import com.fshows.fuiou.response.trade.pay.FuiouWxAndUnionUserIdResponse;

/**
 * 富友交易相关API
 *
 * @author liluqing
 * @version FuiouTradeApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum FuiouApiDefinitionEnum implements IFuiouApiDefinition {
    PRE_ORDER_CREATE(
            "主扫交易（定额码）",
            "/preCreate",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouPreOrderRequest.class,
            FuiouPreOrderResponse.class
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "/micropay",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouScanCardRequest.class,
            FuiouScanCardResponse.class
    ),
    JS_API_PAY(
            "jsapi支付（微信公众号(小程序)、支付宝服务窗(小程序)统一下单）",
            "/wxPreCreate",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouJsApiPayRequest.class,
            FuiouJsApiPayResponse.class
    ),
    WX_AND_UNION_USER_ID(
            "微信授权码查询openid/银联授权码获取user_id",
            "/auth2Openid",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouWxAndUnionUserIdRequest.class,
            FuiouWxAndUnionUserIdResponse.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "/commonRefund",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouRefundRequest.class,
            FuiouRefundResponse.class
    ),
    REFUND_QUERY(
            "退款查询接口",
            "/refundQuery",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouRefundQueryRequest.class,
            FuiouRefundQueryResponse.class
    ),
    REVOKED_CREATE(
            "撤销交易",
            "/cancelorder",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouOrderRevokedRequest.class,
            FuiouOrderRevokedResponse.class
    ),
    ORDER_CLOSE(
            "关单交易",
            "/closeorder",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouOrderCloseRequest.class,
            FuiouOrderCloseResponse.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "/commonQuery",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouOrderQueryRequest.class,
            FuiouOrderQueryResponse.class
    ),
    ORDER_QUERY_HISTORY(
            "历史订单查询",
            "/hisTradeQuery",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouHisOrderQueryRequest.class,
            FuiouOrderQueryResponse.class
    ),
    QUERY_RATE_FEE(
            "订单手续费查询接口",
            "",
            FuiouConstant.TRADE_API_VERSION_V1,
            null,
            null
    ),
    BANK_CARD_PAY_ORDER_QUERY(
            "订单查询接口",
            "/trade/order",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouBankCardPayOrderQueryRequest.class,
            FuiouBankCardPayOrderQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    FuiouApiDefinitionEnum(String name,
                           String apiSubURI,
                           String version,
                           Class requestClass,
                           Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}