/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.order;

import com.fshows.fuiou.response.trade.order.FuiouRefundQueryResponse;
import com.fshows.fuiou.response.trade.order.FuiouRefundResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.enums.FuiouApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.io.Serializable;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version FuiouRefundQueryRequest.java, v 0.1 2023-07-05 11:34:24
 */
@Data
public class FuiouRefundQueryRequest extends FuiouBizRequest<FuiouRefundQueryResponse, FuiouApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555410617276L;


    /**
     * 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 商户系统内部的订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "refundOrderNo长度不能超过30")
    private String refundOrderNo;

}