/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangyi
 * @version QuerySettlementInfoResponse.java, v 0.1 2023-09-25 14:52 wangyi
 */
@Data
public class QuerySettlementInfoResponse implements Serializable {
    private static final long serialVersionUID = 6793812849804051500L;

    /**
     * 商户号
     */
    private String mchntCd;

    /**
     * 清算日期
     */
    private String settleDt;

    /**
     * 金额（分）
     */
    private Long payAmt;

    /**
     * 划拨状态:
     * 1：成功
     * 2：失败
     * 3：划款中
     * 4：已划款,状态未知
     * 5：转入小宝金库
     * 6：退票
     * 7：待退票
     */
    private String paySt;

    /**
     * 划拨状态描述
     */
    private String payStDesc;

    /**
     * 划款交易类型
     * 3022：T1划款
     * 9004：D1划款
     * 9002：划款至小宝理财
     * 9008：商户钱包次日到账
     * 9006：定时到
     * 9016：交班到账
     */
    private String payTxnCd;

    /**
     * 重新划款标识
     */
    private String repayTag;

    /**
     * 重新划款日期
     */
    private String repayDt;

    /**
     * 提现手续费
     */
    private Long d1Fee;

    /**
     * 附加手续费（原结算交易手续费）暂时没有值，启用时间待定
     */
    private Long addnFee;

    /**
     * 划款户名
     */
    private String settleAcntNm;

    /**
     * 划款账号(前六后四，中间三个***)
     */
    private String settleAcntNo;

    /**
     * 划款成功时间，格式为：yyyyMMddHHmmss
     */
    private String payTs;

    /**
     * 划拨失败状态描述
     */
    private String payStErrDesc;

    /**
     * 划款流水号
     */
    private String reservedChnlPaySsn;

    /**
     * 重新划款流水号
     */
    private String reservedRepaySsn;

    /**
     * 原划款流水号
     */
    private String reservedOrigPaySsn;

    /**
     * 原划款时间
     */
    private String reservedOrigSettleDt;
}