/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouUnionpayApplyResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouUnionpayApplyRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouUnionpayApplyRequest extends FuiouBizRequest<FuiouUnionpayApplyResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555911370765L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "traceNo长度不能超过15")
    private String traceNo;

    /**
     * 申请商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 银联凭条打印名称
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "printReceipt长度不能超过20")
    private String printReceipt;

    /**
     * 借记卡扣率 见附件3.银联二维码扣率代码对照表
     * (必填)
     */
    @NotBlank
    @Length(max = 5, message = "debitCardSetCd长度不能超过5")
    private String debitCardSetCd;

    /**
     * 贷记卡扣率 见附件3.银联二维码扣率代码对照表
     * (必填)
     */
    @NotBlank
    @Length(max = 5, message = "creditCardSetCd长度不能超过5")
    private String creditCardSetCd;

    /**
     * 商户子类型 见附件11.商户类别码
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "mchntSubTp长度不能超过4")
    private String mchntSubTp;

    /**
     * 借记卡活动扣率
     * (选填)
     */
    @Length(max = 5, message = "actDebitCardSetCd长度不能超过5")
    private String actDebitCardSetCd;

    /**
     * 贷记卡活动扣率
     * (选填)
     */
    @Length(max = 5, message = "actCreditCardSetCd长度不能超过5")
    private String actCreditCardSetCd;

}