/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.pay;

import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.response.base.FuiouBizResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouPreOrderResponse.java, v 0.1 2023-07-05 11:12:25
 */
@Data
public class FuiouPreOrderResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555218114665L;


    /**
     * 商户号, 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 订单类型:ALIPAY,WECHAT,UNIONPAY(银联二维码),BESTPAY(翼支付)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 预支付交易会话标识,富友返回支付宝生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     *
     * (选填)
     */
    @Length(max = 64, message = "sessionId长度不能超过64")
    private String sessionId;

    /**
     * 二维码链接
     *
     * (选填)
     */
    @Length(max = 64, message = "qrCode长度不能超过64")
    private String qrCode;

    /**
     * 富友生成的订单号,需要商户与商户订单号进行关联
     *
     * (选填)
     */
    @Length(max = 30, message = "reservedFyOrderNo长度不能超过30")
    private String reservedFyOrderNo;

    /**
     * 富友系统内部追踪号
     *
     * (选填)
     */
    @Length(max = 12, message = "reservedFyTraceNo长度不能超过12")
    private String reservedFyTraceNo;

    /**
     * 条码流水号，用户账单二维码对应的流水
     *
     * (选填)
     */
    @Length(max = 64, message = "reservedChannelOrderId长度不能超过64")
    private String reservedChannelOrderId;

}