/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.client.base.IFuiouUploadPicClient;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.response.merchant.FuiouPicUploadResponse;
import com.fshows.fuiou.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuiouUploadPicClientImpl
implements IFuiouUploadPicClient {
    private static final Logger log = LoggerFactory.getLogger(FuiouUploadPicClientImpl.class);
    private String insId;
    private String postUrl;
    private String fuiouMerchantPrivateKey;
    private String charset;

    public FuiouUploadPicClientImpl(String insId, String postUrl, String fuiouMerchantPrivateKey, String charset) {
        this.insId = insId;
        this.postUrl = postUrl;
        this.fuiouMerchantPrivateKey = fuiouMerchantPrivateKey;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FuiouPicUploadResponse uploadPic(Map<String, String> parameters, File file) throws FuiouApiException {
        String responseString;
        block18: {
            responseString = "";
            CloseableHttpClient httpclient = HttpClients.createDefault();
            if (null == parameters || parameters.isEmpty()) {
                return null;
            }
            parameters.put("ins_cd", this.insId);
            parameters.put("sign", this.getSign(parameters));
            try {
                HttpPost httpPost = new HttpPost(this.postUrl);
                MultipartEntityBuilder entity = MultipartEntityBuilder.create();
                for (String key : parameters.keySet()) {
                    entity.addTextBody(key, parameters.get(key), ContentType.DEFAULT_TEXT);
                }
                entity.addPart("file", (ContentBody)new FileBody(file));
                httpPost.setEntity(entity.build());
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(30000).build();
                httpPost.setConfig(requestConfig);
                log.info("\u3010fuiou-sdk\u3011\u56fe\u7247\u4e0a\u4f20\u5165\u53c2 >> request = " + httpPost.getRequestLine());
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() != 200) break block18;
                HttpEntity httpEntity = response.getEntity();
                log.info("\u3010fuiou-sdk\u3011\u56fe\u7247\u4e0a\u4f20\u51fa\u53c2 >> response = " + response.getStatusLine());
                try {
                    if (httpEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)httpEntity);
                        log.info("fuiou-sdk \u56fe\u7247\u4e0a\u4f20\u51fa\u53c2 >> response content:" + responseString);
                        EntityUtils.consume((HttpEntity)httpEntity);
                    }
                }
                finally {
                    response.close();
                }
            }
            catch (Exception e) {
                log.error("http\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (httpclient != null) {
                    try {
                        httpclient.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return StrUtil.isBlank((CharSequence)responseString) ? null : (FuiouPicUploadResponse)JSONObject.parseObject((String)responseString, FuiouPicUploadResponse.class);
    }

    private String getSign(Map<String, String> dataMap) throws FuiouApiException {
        try {
            String waitSignStr = this.getWaitSignStr(dataMap);
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u5f85\u52a0\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", waitSignStr);
            String md5Hex = DigestUtils.md5Hex((byte[])waitSignStr.getBytes(this.charset));
            return md5Hex.toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011fuiou\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> signParam={}", e, dataMap);
            throw new FuiouApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    private String getWaitSignStr(Map<String, String> dataMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"sign") || StringUtils.startsWith((CharSequence)key, (CharSequence)"reserved") || StrUtil.isBlank((CharSequence)value)) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        sb.append("&key=").append(this.fuiouMerchantPrivateKey);
        return sb.toString();
    }
}

