/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.FuiouHttpResult;
import com.fshows.fuiou.client.base.IFuiouApiClient;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.impl.DefaultHttpRequestImpl;
import com.fshows.fuiou.client.impl.DefaultSignerImpl;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.ValidateUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFuiouApiClientImpl
implements IFuiouApiClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractFuiouApiClientImpl.class);
    protected ApiClientConfig apiClientConfig;
    protected IHttpRequest httpRequest;
    protected ISigner signer;

    public AbstractFuiouApiClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = new DefaultHttpRequestImpl();
        this.signer = new DefaultSignerImpl();
    }

    public AbstractFuiouApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = httpRequest;
        this.signer = signer;
    }

    protected FuiouBizResponse doExecute(FuiouBizRequest bizRequest, IFuiouApiDefinition tradeApiDefinitionEnum) throws FuiouApiException {
        try {
            boolean bo;
            this.checkParam(bizRequest, tradeApiDefinitionEnum);
            this.buildFuiouBizRequest(bizRequest, tradeApiDefinitionEnum);
            SignParam signParam = this.buildSignParam(bizRequest);
            String authorization = this.signer.sign(signParam, this.apiClientConfig);
            bizRequest.setSign(authorization);
            String body = this.serializableRequest(bizRequest, authorization, tradeApiDefinitionEnum);
            String url = this.getServerURL(tradeApiDefinitionEnum);
            FuiouHttpResult httpResult = this.requestPost(url, authorization, body);
            FuiouBizResponse response = this.parseResponse(httpResult.getBody(), tradeApiDefinitionEnum);
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u6620\u5c04\u7ed3\u675f >> url={}, request={}, response={}", url, bizRequest, response);
            if (this.apiClientConfig.isVrifySignResponse() && response != null && StringUtils.equals((CharSequence)response.getResultCode(), (CharSequence)"000000") && !(bo = this.signer.verifySign(response.getResMap(), null, this.apiClientConfig).booleanValue())) {
                LogUtil.error(log, "\u3010fuiou-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> httpResult={}", httpResult);
                throw new FuiouApiException("[fuiou-sdk]\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
            }
            return response;
        }
        catch (FuiouApiException e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u5bcc\u53cb\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u5bcc\u53cb\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw new FuiouApiException(e.getMessage(), e);
        }
    }

    protected FuiouHttpResult requestPost(String url, String authorization, String requestBody) throws IOException, FuiouApiException {
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> url={}, authorization={}, request={}", url, authorization, requestBody);
            FuiouHttpResult httpResult = this.httpRequest.post(url, authorization, requestBody, this.apiClientConfig);
            if (httpResult == null) {
                throw new FuiouApiException("fuiou\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> url={}, request={}, response={}, cost={}ms", url, requestBody, httpResult.getBody(), System.currentTimeMillis() - beginTime);
            return httpResult;
        }
        catch (FuiouApiException e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw new FuiouApiException("\u8bf7\u6c42fuiou\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    protected void checkParam(FuiouBizRequest bizRequest, IFuiouApiDefinition fuiouApiDefinition) throws FuiouApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        System.out.println();
        boolean checkRequestClass = StringUtils.equals((CharSequence)bizRequest.getClass().getCanonicalName(), (CharSequence)fuiouApiDefinition.getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new FuiouApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.apiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    protected String getServerURL(IFuiouApiDefinition tradeApiDefinitionEnum) {
        return this.apiClientConfig.getApiParentURL() + tradeApiDefinitionEnum.getApiSubURI();
    }

    protected abstract FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest var1, IFuiouApiDefinition var2);

    protected abstract SignParam buildSignParam(FuiouBizRequest var1);

    protected abstract String serializableRequest(FuiouBizRequest var1, String var2, IFuiouApiDefinition var3);

    protected abstract FuiouBizResponse parseResponse(String var1, IFuiouApiDefinition var2) throws FuiouApiException;

    public void setApiClientConfig(ApiClientConfig apiClientConfig) {
        this.apiClientConfig = apiClientConfig;
    }

    public void setHttpRequest(IHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setSigner(ISigner signer) {
        this.signer = signer;
    }
}

