/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouMerchantQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouMerchantQueryRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouMerchantQueryRequest extends FuiouBizRequest<FuiouMerchantQueryResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555744428854L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 商户号，商户名称二者选其一传值，字段是必须传的（不支持模糊查询）
     * (选填)
     */
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 商户名称，商户名称二者选其一传值，字段是必须传的（不支持模糊查询）
     * (选填)
     */
    @Length(max = 15, message = "mchntName长度不能超过15")
    private String mchntName;

}