/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 业务请求参数的基础父类
 *
 * @author liluqing
 * @version FuiouBizRequest.java, v 0.1 2022-03-01 20:19
 */
@Data
public class FuiouBizRequest<T extends FuiouBizResponse, E extends IFuiouApiDefinition> implements Serializable {

    private static final long serialVersionUID = 3579701521402004039L;

    /**
     * 版本
     */
    private String version;

    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;

    /**
     * 随机字符串
     */
    private String randomStr;

    /**
     * 签名
     */
    private String sign;
}