/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.order;

import lombok.Data;
import com.fshows.fuiou.response.base.FuiouBizResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouOrderQueryResponse.java, v 0.1 2023-07-05 10:54:02
 */
@Data
public class FuiouOrderQueryResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555784300387L;


    /**
     * 商户号, 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 买家在渠道(微信、支付宝)的用户ID
     *
     * (选填)
     */
    @Length(max = 128, message = "buyerId长度不能超过128")
    private String buyerId;

    /**
     * 订单类型:ALIPAY，WECHAT
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 查询状态，详见应答码表--查询应答码
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "transStat长度不能超过32")
    private String transStat;

    /**
     * 订单金额，单位为分
     *
     * (必填)
     */
    @NotNull
    private Integer orderAmt;

    /**
     * 渠道订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "transactionId长度不能超过64")
    private String transactionId;

    /**
     * 商户订单号, 商户系统内部的订单号 (5到30个字符、只能包含字母数字,区分大小写)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

    /**
     * 附加数据
     *
     * (选填)
     */
    @Length(max = 50, message = "addnInf长度不能超过50")
    private String addnInf;

    /**
     * 富友交易日期
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "reservedFySettleDt长度不能超过8")
    private String reservedFySettleDt;

    /**
     * 优惠金额(分)
     *
     * (选填)
     */
    @Length(max = 10, message = "reservedCouponFee长度不能超过10")
    private String reservedCouponFee;

    /**
     * 买家在渠道登录账号
     *
     * (选填)
     */
    @Length(max = 128, message = "reservedBuyerLogonId长度不能超过128")
    private String reservedBuyerLogonId;

    /**
     * 支付宝交易资金渠道，详细渠道
     *
     * (选填)
     */
    private String reservedFundBillList;

    /**
     * 富友系统内部追踪号
     *
     * (选填)
     */
    @Length(max = 12, message = "reservedFyTraceNo长度不能超过12")
    private String reservedFyTraceNo;

    /**
     * 条码流水号，用户账单二维码对应的流水
     *
     * (选填)
     */
    @Length(max = 64, message = "reservedChannelOrderId长度不能超过64")
    private String reservedChannelOrderId;

    /**
     * 富友终端号(富友终端号与TUSN号二选一)
     *
     * (选填)
     */
    @Length(max = 8, message = "reservedFyTermId长度不能超过8")
    private String reservedFyTermId;

    /**
     * 1--表示信用卡 或者花呗 0--表示其他(非信用方式) 不填，表示未知
     *
     * (选填)
     */
    @Length(max = 8, message = "reservedIsCredit长度不能超过8")
    private String reservedIsCredit;

    /**
     * 用户支付时间yyyyMMddHHmmss
     *
     * (选填)
     */
    @Length(max = 14, message = "reservedTxnFinTs长度不能超过14")
    private String reservedTxnFinTs;

    /**
     * 应结算订单金额，分为单位的整数。 只有成功交易才会返回 如果使用了商户免充值优惠券，该值为订单金额-商户免充值 如果没有使用商户免充值，该值等于订单金额
     *
     * (选填)
     */
    private Integer reservedSettlementAmt;

    /**
     * 付款方式
     *
     * (选填)
     */
    @Length(max = 16, message = "reservedBankType长度不能超过16")
    private String reservedBankType;

    /**
     * 微信营销详情（资金单位：分），见文档中reserved_promotion_detail说明字段
     *
     * (选填)
     */
    @Length(max = 6000, message = "reservedPromotionDetail长度不能超过6000")
    private String reservedPromotionDetail;

    /**
     * 支付宝交易支付时所使用的所有优惠券信息（资金单位：元） "[{"amount":"1.00","merchant_contribute":"1.00", "name":"1.00元代金券","other_contribute":"0.00", "template_id":"20221107000730017617007JGOUG", "id":"202211070007300282330EB2Y9QQ", "type":"ALIPAY_BIZ_VOUCHER"}]"
     *
     * (选填)
     */
    private String reservedVoucherDetailList;

    /**
     * 支付宝交易支付所使用的单品券优惠的商品优惠信息（资金单位：元） "[{"goodsId":"STANDARD1026181538"," goodsName":"雪碧","discountAmount":"10.00"}]"
     *
     * (选填)
     */
    private String reservedDiscountGoodsDetail;

    /**
     * 返回值：1=商户出息
     *
     * (选填)
     */
    @Length(max = 1, message = "reservedHbIsSeller长度不能超过1")
    private String reservedHbIsSeller;

    /**
     * 手续费减免标识 Y：表示减免（默认） N：表示不减免
     *
     * (选填)
     */
    @Length(max = 1, message = "reservedServiceChargeFlag长度不能超过1")
    private String reservedServiceChargeFlag;

    /**
     * 交易子商户号
     *
     * (选填)
     */
    private String reservedSubMchntCd;

}