/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.pay;

import com.fshows.fuiou.enums.FuiouApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.trade.pay.FuiouWxAndUnionUserIdResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouPreOrderRequest.java, v 0.1 2023-07-05 11:12:25
 */
@Data
public class FuiouWxAndUnionUserIdRequest extends FuiouBizRequest<FuiouWxAndUnionUserIdResponse, FuiouApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -7813891631306045788L;

    /**
     * 商户号, 富友分配给二级商户的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 1、微信：微信分配的子商户公众账号ID
     * 2、银联：填空或填固定值: UnionPay/1.0 CloudPay
     * 填错获取不到user_id
     * 目前仅支持云闪付，待后期其他APP支持后，填写其他银行APP的User Agent
     *
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;


    /**
     * 扫码支付授权码，设备读取用户的条码或者二维码信息
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "authCode长度不能超过128")
    private String authCode;

    /**
     * 实时交易终端IP(后期富友、银联侧风控主要依据，请真实填写) 暂时仅支持IPV4
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "termIp长度不能超过16")
    private String termIp;

    /**
     * 订单类型：
     * 1、微信：WECHAT
     * 2、银联：UNIONPAY(测试环境不可测试)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 13, message = "orderType长度不能超过13")
    private String orderType;

    /**
     * 订单金额，单位为分（暂时无用，后期拓展字段）
     *
     * (选填)
     */
    private Integer orderAmt;
}