/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouPicUploadResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.Serializable;

/**
 * @author
 * @version FuiouPicUploadRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouPicUploadRequest extends FuiouBizRequest<FuiouPicUploadResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555701064174L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 已在富友入网的富友商户代码
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 文件名称
     * (必填)
     */
    @NotBlank
    @Length(max = 256, message = "fileName长度不能超过256")
    @JSONField(name = "file_name")
    private String fileName;

    /**
     * 图片文件
     * (必填)
     */
    @NotNull
    private File file;

}