/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.client.base;

import com.fshows.fuiou.constant.CommonConstant;
import com.fshows.fuiou.enums.base.SignTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 客户端配置信息model
 *
 * @author liluqing
 * @version ClientMetaInfoModel.java, v 0.1 2022-03-01 20:37
 */
@Data
public class ApiClientConfig {

    /**
     * 富友接口网关根URL
     */
    @NotBlank(message = "富友api客户端网关根地址不能为空")
    protected String apiParentURL;

    /**
     * appid
     */
    @NotBlank(message = "富友api客户端appId不能为空")
    protected String appId;

    /**
     * 用于加签的付呗私钥
     */
    @NotBlank(message = "富友api客户端付呗私钥不能为空")
    protected String fubeiPrivateKey;

    /**
     * 用于验签的富友公钥
     */
    @NotBlank(message = "富友api客户端富友公钥不能为空")
    protected String fuiouPublicKey;

    /**
     * 用于加签的付呗私钥
     */
    @NotBlank(message = "富友api客户端付呗进件私钥不能为空")
    protected String fuiouMerchantPrivateKey;

    /**
     * 加签算法类型
     */
    protected SignTypeEnum signTypeEnum = SignTypeEnum.MD5WithRSA;

    /**
     * 是否对富友响应结果进行验签
     */
    protected boolean vrifySignResponse = true;

    /**
     * 是否对参数进行前置校验
     */
    protected boolean checkParam = true;

    /**
     * http连接超时时间
     */
    protected int connectionTimeout = CommonConstant.DEFAULT_CONNECTION_TIMEOUT;

    /**
     * http response读取超时时间
     */
    protected int readTimeout = CommonConstant.DEFAULT_READ_TIMEOUT;

    /**
     * 默认编码格式，默认为utf-8
     */
    protected String charset = CommonConstant.GBK;

}