/*
 * Decompiled with CFR 0.152.
 */
package com.frt.fubeiopenapisdk.client;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.frt.fubeiopenapisdk.apienum.FubeiMerchantApiDefinitionEnum;
import com.frt.fubeiopenapisdk.client.model.FubeiApiRequestModel;
import com.frt.fubeiopenapisdk.client.model.FubeiMerchantClientConfigModel;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import com.frt.fubeiopenapisdk.utils.MD5;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FubeiMerchantApiClient
extends AbstractApiClient<FubeiBizRequest, FubeiBizResponse, FubeiMerchantApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(FubeiMerchantApiClient.class);

    public FubeiMerchantApiClient(FubeiMerchantClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    @Override
    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u4ed8\u5457\u652f\u4ed8");
        clientInfoModel.setClientCode("fubei-openapi-sdk");
        return clientInfoModel;
    }

    @Override
    protected void checkParam(FubeiBizRequest bizRequest, DefaultRequestContext defaultRequestContext) throws FsApiException {
        super.checkParam(bizRequest, defaultRequestContext);
        if (StrUtil.isEmpty(bizRequest.getVendorSn())) {
            throw new FsApiException("\u8bf7\u6c42\u5f02\u5e38vendorSn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty(bizRequest.getAppSecret())) {
            throw new FsApiException("\u8bf7\u6c42\u5f02\u5e38appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    protected DefaultRequestContext buildRequestContext(FubeiMerchantApiDefinitionEnum iApiDefinition, FubeiBizRequest request, DefaultClientConfigModel merchantConfig) {
        FubeiMerchantClientConfigModel clientConfig = (FubeiMerchantClientConfigModel)this.apiClientConfig;
        FubeiMerchantClientConfigModel config = new FubeiMerchantClientConfigModel();
        config.setApiParentURL(clientConfig.getApiParentURL());
        config.setCharset(clientConfig.getCharset());
        config.setTimeout(clientConfig.getTimeout());
        config.setReadTimeout(clientConfig.getReadTimeout());
        DefaultRequestContext context = new DefaultRequestContext();
        context.setIApiDefinition(iApiDefinition);
        context.setApiClientConfig(config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    @Override
    protected ApiRequestModel buildApiRequestModel(FubeiBizRequest request, DefaultRequestContext context) {
        FubeiMerchantClientConfigModel configModel = (FubeiMerchantClientConfigModel)context.getApiClientConfig();
        FubeiApiRequestModel apiRequestModel = new FubeiApiRequestModel();
        apiRequestModel.setApiURL(configModel.getApiParentURL());
        apiRequestModel.setContentType("application/json");
        apiRequestModel.setVendorSn(request.getVendorSn());
        apiRequestModel.setAppSecret(request.getAppSecret());
        String requestJson = JSON.toJSONString((Object)request);
        request.setVendorSn(null);
        request.setAppSecret(null);
        apiRequestModel.setRequestBody(requestJson);
        return apiRequestModel;
    }

    @Override
    protected FubeiBizResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject dataJson = null;
        try {
            String responseBody = apiResponseModel.getResponseBody();
            JSONObject resJson = JSONObject.parseObject((String)responseBody);
            try {
                dataJson = resJson.getJSONObject("data");
                resJson.remove((Object)"data");
                if (dataJson == null) {
                    dataJson = new JSONObject();
                }
                dataJson.putAll((Map)resJson);
            }
            catch (ClassCastException e) {
                JSONArray jsonArray = resJson.getJSONArray("data");
                resJson.remove((Object)"data");
                if (dataJson == null) {
                    dataJson = new JSONObject();
                }
                dataJson.putAll((Map)resJson);
                dataJson.put("list", (Object)jsonArray);
            }
            return (FubeiBizResponse)JSONObject.parseObject((String)dataJson.toJSONString(), requestContext.getIApiDefinition().getResponseClass());
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u54cd\u5e94\u5f02\u5e38 >> iApiDefinition={}, request={}, \u4e1a\u52a1\u54cd\u5e94\u62a5\u6587dataJson={}", e, this.getClientInfo().getClientDesc(), requestContext.getIApiDefinition(), apiRequestModel.getRequest(), dataJson);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        FubeiApiRequestModel fubeiApiRequestModel = (FubeiApiRequestModel)apiRequestModel;
        String appSecret = fubeiApiRequestModel.getAppSecret();
        String vendorSn = fubeiApiRequestModel.getVendorSn();
        JSONObject jsonParam = new JSONObject(new TreeMap());
        jsonParam.put("nonce", (Object)System.currentTimeMillis());
        jsonParam.put("vendor_sn", (Object)vendorSn);
        jsonParam.put("version", (Object)"1.0");
        jsonParam.put("method", (Object)requestContext.getIApiDefinition().getApiURI());
        jsonParam.put("format", (Object)"json");
        jsonParam.put("sign_method", (Object)"md5");
        jsonParam.put("biz_content", (Object)apiRequestModel.getRequestBody());
        Set keys = jsonParam.keySet();
        StringBuilder signStr = new StringBuilder();
        for (String key : keys) {
            signStr.append(key).append("=").append(jsonParam.get((Object)key)).append("&");
        }
        String signWithSecret = signStr.substring(0, signStr.length() - 1) + appSecret;
        String sign = MD5.sign(signWithSecret, "utf-8");
        jsonParam.put("sign", (Object)sign.toUpperCase());
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String body = ((HttpRequest)((HttpRequest)HttpUtil.createPost(apiClientConfig.getApiParentURL()).header(Header.CONTENT_TYPE, apiRequestModel.getContentType())).charset(apiClientConfig.getCharset())).timeout(apiClientConfig.getReadTimeout()).body(JSONUtil.toJsonStr(jsonParam), apiRequestModel.getContentType()).execute().body();
        ApiResponseModel apiResponseModel = new ApiResponseModel();
        apiResponseModel.setResponseBody(body);
        return apiResponseModel;
    }

    @Override
    public FubeiBizResponse execute(FubeiBizRequest request, FubeiMerchantApiDefinitionEnum apiDefinition) throws FsApiException {
        return (FubeiBizResponse)this.doExecute(request, apiDefinition);
    }

    @Override
    public FubeiBizResponse execute(FubeiBizRequest request, FubeiMerchantApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    @Override
    protected FubeiBizResponse doExecute(FubeiBizRequest request, FubeiMerchantApiDefinitionEnum iApiDefinition, DefaultClientConfigModel customConfig) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, customConfig);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            LogUtil.info(log, "{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", this.getClientInfo().getClientDesc(), iApiDefinition, JSONObject.toJSONString((Object)apiRequestModel.getRequestBody()));
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            FubeiBizResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info(log, "{} >> \u6267\u884c\u8bf7\u6c42\u7ed3\u675f >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms", requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getRequestBody()), JSONObject.toJSONString((Object)response), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime);
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error(log, "{} >> \u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", e, requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)apiRequestModel), JSONObject.toJSONString(apiResponseModel));
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", e, requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)apiRequestModel), JSONObject.toJSONString(apiResponseModel));
            throw new FsApiException("\u8bf7\u6c42\u672a\u77e5\u5f02\u5e38", e);
        }
    }
}

