/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.response.FubeiPayBizResponse;
import lombok.Data;

/**
 * @author zhoujp
 * @version AlipayWapPayResult.java, v 0.1 2022年08月30日15:15:58
 */
@Data
public class FubeiPayOrderWapCreateResponse extends FubeiPayBizResponse {

    /**
     * 订单号
     */
    @JSONField(name = "order_sn")
    private String orderSn;

    /**
     * 第三方订单号
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;

    /**
     * 设备编号
     */
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 商品描述
     */
    @JSONField(name = "body")
    private String body;

    /**
     * 生活圈门店id
     */
    @JSONField(name = "store_id")
    private Integer storeId;

    /**
     * 收银员id
     */
    @JSONField(name = "cashier_id")
    private Integer cashierId;

    /**
     * 附加数据
     * 该字段主要用于商户携带订单的自定义数据
     */
    @JSONField(name = "attach")
    private String attach;

    /**
     * 自动跳转到支付页的html片段
     */
    @JSONField(name = "html")
    private String html;

    /**
     * 用于唤起支付宝收银台的字符串(app支付返回)
     */
    @JSONField(name = "order_str")
    private String orderStr;

    /**
     * 预支付Id
     */
    @JSONField(name = "prepay_id")
    private String prepayId;
}