/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.response.FubeiPayBizResponse;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wangyi
 * @version FubeiPayOrderRefundResponse.java, v 0.1 2025-09-08 16:50 wangyi
 */
@Data
public class FubeiPayOrderRefundQueryResponse extends FubeiPayBizResponse {

    /**
     * 订单号
     */
    @JSONField(name = "order_sn")
    private String orderSn;

    /**
     * 退款单号
     */
    @JSONField(name = "refund_sn")
    private String refundSn;

    /**
     * 商户单号
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;

    /**
     * 商户退款单号
     */
    @JSONField(name = "merchant_refund_sn")
    private String merchantRefundSn;

    /**
     * 退款状态
     */
    @JSONField(name = "refund_status")
    private String refundStatus;

    /**
     * 退款金额
     */
    @JSONField(name = "refund_amount")
    private BigDecimal refundAmount;

    /**
     * 退款完成时间
     */
    private String finishTime;

    /**
     * handler 发起退款者的USERS表ID.
     */
    @JSONField(name = "handler")
    private Integer handler;

    /**
     * 设备硬件号
     */
    @JSONField(name = "device_no")
    private String deviceNo;


    /**
     *  退款失败原因
     */
    private String refundReason;


    /**
     * 退款手续费
     */
    @JSONField(name = "refund_fee")
    private BigDecimal refundFee;
    /**
     * 退款补贴金，单位：元
     * 万达购券单退款必传且大于等于0
     */
    @JSONField(name = "subsidy_amount")
    private BigDecimal subsidyAmount;

}