/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.account.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhangling
 * @version AccountFixQueryDataResponse.java, v 0.1 2025-11-04 10:15 zhangling
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class AccountFixQueryDataResponse implements Serializable {
    private static final long serialVersionUID = 7839369002466717953L;
    /**
     * 分账订单号
     */
    private String orderNo;
    /**
     * 分账金额（元）
     */
    private BigDecimal shareAmount;
    /**
     * 分账出账户，即付呗商户号
     */
    private Integer accountOut;
    /**
     * 入账户id，当账户类型为1时表示分账接收方，当账户类型为2时表示付呗商户号
     */
    private String accountIn;
    /**
     * 账户类型：1 分账接收方、2 商户
     */
    private Integer accountType;
    /**
     * 分账状态：NOSUBMIT 未分账，PROCESSING 分账中，SUCCESS 分账成功，FAIL 分账失败
     */
    private String shareStatus;
    /**
     * 分账时间，格式为yyyyMMddHHmmss
     */
    private String shareTime;
    /**
     * 失败原因
     */
    private String failMessage;
    /**
     * 备注
     */
    private String remark;
}