/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.request.FubeiPayBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author zhoujp
 * @version OrderRefundParam.java, v 0.1 2019-11-14 14:09 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiPayOrderRefundRequest extends FubeiPayBizRequest {
    private static final long serialVersionUID = -8958282994809444239L;

    /**
     * 付呗商户号，以服务商级接入时必传，以商户级接入时不传
     */
    @JSONField(name = "merchant_id")
    private String merchantId;

    /**
     * 付呗订单号
     * 如果同时存在三者优先级为：order_sn>ins_order_sn>merchant_order_sn
     */
    @JSONField(name = "order_sn")
    private String orderSn;

    /**
     * 机构订单号
     */
    @JSONField(name = "ins_order_sn")
    private String insOrderSn;

    /**
     * 外部系统订单号
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;
    /**
     * 退款操作人
     */
    @JSONField(name = "handler")
    private Integer handler;

    /**
     * 设备硬件号
     */
    @JSONField(name = "device_no")
    private String deviceNo;

    /**
     * 外部系统退款号
     */
    @NotBlank(message = "不能为空")
    @Length(max = 32, message = "不符合规范")
    @JSONField(name = "merchant_refund_sn")
    private String merchantRefundSn;

    /**
     * 退款总金额，单位为元
     */
    @NotNull(message = "不能为空")
    @DecimalMax(value = "10000000",message = "退款金额超过上限")
    @DecimalMin(value = "0.01",message = "退款金额低于下限")
    @Digits(integer = 10, fraction = 2)
    @JSONField(name = "refund_amount")
    private BigDecimal refundAmount;

    /**
     * 退款描述
     */
    @Length(max = 255,message = "不符合规范")
    @JSONField(name = "refund_reason")
    private String refundReason;

    /**
     * 退款通知地址
     */
    @Length(max = 255,message = "不符合规范")
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * 附加数据，原样返回
     */
    @Length(max = 255,message = "不符合规范")
    @JSONField(name = "attach")
    private String attach;
}