/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.request.FubeiPayBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 *
 *
 * @author wangyi
 * @version FubeiPayOrderRefundQueryRequest.java, v 0.1 2025-09-08 16:23 wangyi
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiPayOrderRefundQueryRequest extends FubeiPayBizRequest {

    /**
     * 付呗商户号，以服务商级接入时必传，以商户级接入时不传
     */
    @JSONField(name = "merchant_id")
    private String merchantId;

    /**
     * 付呗退款号，与外部系统退款号不能同时为空（二选一），如果同时存在优先取refund_sn
     */
    @JSONField(name = "refund_sn")
    private String refundSn;

    /**
     * 外部系统退款号，与付呗退款号不能同时为空（二选一）
     */
    @JSONField(name = "merchant_refund_sn")
    private String merchantRefundSn;
}