/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 门店信息
 *
 * @author buhao
 * @version ShopInfo.java, v 0.1 2021-08-10 15:05 buhao
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class ShopInfoRequest {

    /**
     * 门店名称
     */
    @Size(min = 2, max = 20, message = "门店名称长度在2~20之间")
    private String storeName;

    /**
     * 门店电话
     */
    @Size(max = 16, message = "门店电话超长")
    private String storePhone;

    /**
     * 经营场所内设照片
     * 请先使用图片上传上传，上传成功后填写对应的图片地址
     */
    @NotBlank(message = "经营场所内设照片不能为空")
    private String storeEnvPhoto;

    /**
     * 门头照
     */
    @NotBlank(message = "门头照不能为空")
    private String storeFrontPhoto;

    /**
     * 收银台照片
     */
    @NotBlank(message = "收银台照片")
    private String storeCashPhoto;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
