/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * 商户基本信息
 *
 * @author buhao
 * @version BaseInfo.java, v 0.1 2021-08-10 11:55 buhoa
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class BaseInfoRequest {
    /**
     * 1: 个人
     * 2: 个体
     * 3: 企业
     */
    @NotNull(message = "商户类型不能为空")
    @Min(value = 1)
    @Max(value = 3)
    private Integer merchantType;

    /**
     * 商户子类型（非必填）
     * 不填默认（1、普通企业）
     * 1、普通企业
     * 2、事业单位
     * 3、其他组织
     */
    @Min(value = 1, message = "商户子类型不合法")
    @Max(value = 3, message = "商户子类型不合法")
    private Integer merchantChildType;

    /**
     * 商户简称
     * 不能为纯数字（可允许全英文）
     * 不能包含：藏独,法轮功,色情,毒品,赌博,博彩,基金,理财,担保,贷款,集资,P2P,麻醉,间谍服务,私人侦探,股权,众筹,
     * 乐刷,套现,千万户,000,t0,信用卡,官方,担保,资金,淘宝,财务,收款,超时,商圈
     */
    @NotBlank(message = "商户简称不能为空")
    @Size(min = 2, max = 20, message = "商户简称超长")
    private String merchantShortName;

    /**
     * 客服电话
     */
    @Size(max = 20, message = "客服电话超长")
    private String servicePhone;

    /**
     * 商户手机号
     */
    @Size(min = 11, max = 11, message = "商户手机号长度不是11位")
    @Pattern(regexp = "\\d{11}", message = "商户手机号格式无效")
    private String contactPhone;

    /**
     * 商户电子邮箱
     */
    @Email
    @Length(max = 32)
    private String email;

    /**
     * 行业类目
     */
    @NotNull(message = "行业类目不能为空")
    private Integer unityCategoryId;

    /**
     * 通道标识 15 直连随行付 21 直连乐刷 26联动
     */
    private Integer liquidationType;

    /**
     * 开户方式
     * OFFLINE--线下通道
     * ONLINE--线上通道
     * 为空就是默认线下渠道
     */
    private String operationalType;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
