/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import lombok.Data;

import java.io.Serializable;

/**
 *
 *
 * @author weikunpeng
 * @version assistInfoParam.java, v 0.1 2025-10-17 16:28 weikunpeng
 */
@Data
public class AssistInfoRequest implements Serializable {

    private static final long serialVersionUID = 629216678932807722L;

    /**
     * 小微经营类型
     * ● MICRO_TYPE_STORE:  固定门店场所
     * ● MICRO_TYPE_MOBILE:  流动经营/便民服务
     * ● MICRO_TYPE_ONLINE:  线上商品/服务交易
     * 不传默认使用MICRO_TYPE_STORE
     */
    private String microType;

    /**
     * 门店名称
     * 1、流动经营/便民服务：填写经营/服务名称
     * 2、线上商品/服务交易：填写线上店铺名称
     * 2、格式规范：
     * 长度为1-50个字符
     * 前后不能有空格、制表符、换行符
     * 不能仅含数字、特殊字符
     * 仅能填写数字、英文字母、汉字及特殊字符
     * 不传默认使用门店名称
     */
    private String storeName;

    /**
     * 【门店省市编码】 1、只能由数字组成
     * 2、详细参见微信支付提供的省市对照表
     * 3、填写规范：
     * 门店场所：填写门店省市编码
     * 流动经营/便民服务：填写经营/服务所在地省市编码
     * 线上商品/服务交易：填写卖家所在地省市编码
     * 不传默认使用经营地址市码
     */
    private String addressCode;

    /**
     * 【门店地址】
     *  1、填写规范：
     * 门店场所：填写店铺详细地址，具体区/县及街道门牌号或大厦楼层
     * 流动经营/便民服务：填写“无”
     * 线上商品/服务交易：填写电商平台名称
     * 2、格式规范：
     * 长度为4-512个字符
     * 前后不能有空格、制表符、换行符
     * 不能仅含数字、特殊字符
     * 仅能填写数字、英文字母、汉字及特殊字符
     * 不传默认使用商户地址
     */
    private String address;

    /**
     * 【门店门头照片】
     *  1、请上传门头正面照片（要求门店招牌、门框完整、清晰、可辨识）；若为停车场等无固定门头照片的经营场所，可上传岗亭/出入闸口
     * 不传默认使用门头照
     */
    private String storeHeaderPic;

    /**
     * 【店内环境照片】 1、请上传门头正面照片（要求门店招牌、门框完整、清晰、可辨识）；若为停车场等无固定门头照片的经营场所，可上传岗亭/出入闸口
     * 不传默认使用环境照
     */
    private String storeIndoorPic;
}