/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 结算信息
 *
 * @author zhaoyi
 * @version AccountInfo.java, v 0.1 2020-07-27 14:51 zhaoyi
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class AccountInfoRequest implements Serializable {

    private static final long serialVersionUID = -5204422318614412117L;

    /**
     * 账户类型
     * 1：个人账户
     * 2：公司账户
     */
    @NotNull(message = "账户类型不能为空")
    @Min(value = 1)
    @Max(value = 2)
    private Integer accountType;

    /**
     * 结算标志
     */
    @NotNull(message = "结算标志不能为空")
    @Min(value = 0)
    @Max(value = 1)
    private Integer legalFlag;


    /**
     * 开户支行联行号
     */
    @NotBlank(message = "开户支行联行号不能为空")
    @Size(max = 20, message = "开户支行联行号超长")
    private String unionpayCode;

    /**
     * 开户名；
     * （法人结算：与法人姓名姓名一致；
     * 企业账户：与营业执照注册名称一致）
     */
    @NotBlank(message = "开户名不能为空")
    private String realName;

    /**
     * 结算人证件(个人账户必传，非法人结算只能是身份证)，法人结算与法人证件号一致
     */
    @Size(max = 18, message = "结算人证件超长")
    private String idCardNo;

    /**
     * 结算人身份证人像面照片
     * 非法人结算必填，
     * 法人结算时直接取法人身份证照片
     */
    private String idCardFrontPhoto;

    /**
     * 结算人身份证人像面照片
     * 非法人结算必填，法人结算可不填
     * 法人结算时直接取法人身份证照片
     */
    private String idCardBackPhoto;

    /**
     * 银行预留号码
     */
    @Size(min = 11, max = 11, message = "银行预留号码长度不是11位")
    @Pattern(regexp = "\\d{11}", message = "银行预留号码格式无效")
    private String bankCellPhone;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空")
    @Size(max = 24, message = "银行卡号超长")
    private String bankCardNo;

    /**
     * 银行卡正面（如是对公账户，开户许可证）图片地址
     */
    @NotBlank(message = "银行卡正面图片地址不能为空")
    private String bankCardPhoto;

    /**
     * 非法人结算授权书
     * 非法人结算模式必传。
     * 用最新的非法人结算授权书模版，在下方对接接口列表里有模版
     */
    private String unincorporatedPhoto;

    /**
     * 结算周期
     * 0-D0
     * 1-D1
     */
    private Integer withdrawType;

    /**
     * 结算人身份证姓名（企业非同名结算时必填）
     */
    private String settlerIdCardName;

    /**
     * 结算人证件类型（非必填，不填默认1-身份证）
     * 1-身份证(默认)；
     * 2-香港通行证（回乡证）;
     * 3-台湾身份证；
     * 4-香港身份证；
     * 5-澳门身份证；
     * 6-护照；
     * 7-居住证；
     * 9-其它法定文件;
     * 10-台湾通行证(台胞证);
     * 11-澳门通行证（回乡证）;
     * 12-临时身份证
     */
    private Integer settleIdentityType;

    /**
     * 结算人身份证有效期开始日期：yyyy-MM-dd
     */
    private String settlerIdCardBeginDate;

    /**
     * 结算人身份证有效期结束日期：yyyy-MM-dd
     */
    private String settlerIdCardEndDate;


    /**
     * 联行号是否手动填写：0否，1手动
     */
    private Integer isHandle;

    /**
     * 对公账户信息
     * (双账户的时候需要进行补充)
     */
    private PublicAccountInfoRequest publicAccountInfoParam;

    /**
     * 法人/结算人手持授权书照片
     * 入驻通道 = 国通星驿 and 非法人结算时必填
     */
    private String settlerNoLegalProveGroupPic;

    /**
     * 结算人站收银台照片
     * 国通星驿 and 小微商户时必传
     */
    private String settlerStandingCashPic;

    /**
     * 签约相关信息
     */
    private SignInfoRequest signInfoParam;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
