package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantQueryStatusRequest extends FubeiBizRequest {

    /**
     * 付呗商户号
     */
    private Integer merchantId;
    /**
     * 商户账号，与付呗商户号二选一
     */
    @Length(max = 60, message = "不符合规范")
    private String merchantCode;

}
