/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhoujp
 * @version SubAccountUpdateParam.java, v 0.1 2019-11-05 16:07 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiSubAccountUpdateRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -5678589817635402368L;

    /**
     * 请求流水号 与分账接收方id二选一
     */
    private String merchantOrderSn;

    /**
     * 分账接收方id，与请求流水号二选一
     */
    private String accountId;

    /**
     * 结算银行卡号
     */
    @NotBlank(message = "不能为空")
    private String accountNo;

    /**
     * 开户总行，如中国建设银行
     */
    private String bankName;

    /**
     * 开户支行
     */
    private String branchName;

    /**
     * 联行号，对公必填
     */
    private String bankNo;

    /**
     * 结算银行卡照片
     */
    @NotNull(message = "结算银行卡照片必传")
    private String bankCardPhoto;
}