/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhoujp
 * @version SubAccountIncomeParam.java, v 0.1 2019-11-05 16:07 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiSubAccountIncomeRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -5678589817635402368L;

    /**
     * 请求流水号
     */
    @NotBlank(message = "不能为空")
    private String merchantOrderSn;

    /**
     * 客户名称
     */
    @Length(min = 2, max = 32, message = "商户名称长度不规范")
    @NotBlank(message = "不能为空")
    private String account;

    /**
     * 客户类型. 1企业 2小微 3个体工商户
     */
    @NotNull(message = "不能为空")
    private Integer businessType;

    /**
     * 营业执照号，当客户类型为企业时必填
     */
    private String licenseNo;

    /**
     * 营业执照名称
     */
    private String licenseName;

    /**
     * 营业执照照片，当客户类型为企业时必填
     */
    private String licensePhoto;

    /**
     * 营业执照有效期开始时间，格式为yyyyMMdd
     */
    private String licenseTimeBegin;

    /**
     * 营业执照有效期结束时间，格式为yyyyMMdd，若永久则不传
     */
    private String licenseTimeEnd;

    /**
     * 法人姓名，企业填营业执照上的法人姓名；个体工商户填持卡人姓名。
     */
    @NotBlank(message = "不能为空")
    private String legalPersonName;

    /**
     * 法人证件类型，企业填营业执照上的法人证件类型；个体工商户填持卡人证件类型。
     */
    @NotBlank(message = "不能为空")
    private String legalPersonIdCardType;

    /**
     * 法人证件号，企业填营业执照上的法人号码；个体工商户填持卡人证件号。
     */
    @NotBlank(message = "不能为空")
    private String legalPersonIdCardNo;

    /**
     * 法人证件正面照片
     */
    @NotBlank(message = "不能为空")
    private String legalPersonIdCardFrontPhoto;

    /**
     * 法人证件反面照片
     */
    @NotBlank(message = "不能为空")
    private String legalPersonIdCardBackPhoto;

    /**
     * 结算人证件类型，枚举值：持卡人证件类型
     * IDCARD:身份证 LICENSE:营业执照
     */
    private String idCardType;

    /**
     * 结算人证件号
     */
    private String idCardNo;

    /**
     * 结算人证件正面照片
     */
    private String settlementPersonIdCardFrontPhoto;

    /**
     * 结算人证件反面照片
     */
    private String settlementPersonIdCardBackPhoto;

    /**
     * 结算账户类型，枚举值：1 对公 2 对私
     */
    @NotNull(message = "不能为空")
    private Integer accountType;

    /**
     * 结算银行卡号
     */
    @NotBlank(message = "不能为空")
    private String accountNo;

    /**
     * 结算银行开户名
     */
    private String accountName;

    /**
     * 开户总行，如中国建设银行
     */
    private String bankName;

    /**
     * 开户支行
     */
    private String branchName;

    /**
     * 联行号，对公必填
     */
    private String bankNo;

    /**
     * 预留手机号，11位数字，用于提现失败通知等
     */
    @NotBlank(message = "不能为空")
    private String bankCellPhone;

    /**
     * 门头照
     */
    private String storeFrontImgUrl;

    /**
     * 收银台照片
     */
    private String storeCashPhoto;

    /**
     * 店内环境照
     */
    private String storeEnvPhoto;

    /**
     * 省份编码
     */
    @Length(max = 16, message = "不符合规范")
    private String provinceCode;
    /**
     * 城市编码
     */
    @Length(max = 16, message = "不符合规范")
    private String cityCode;
    /**
     * 区域编码
     */
    @Length(max = 16, message = "不符合规范")
    private String areaCode;
    /**
     * 详细地址
     */
    @Length(max = 128, message = "不符合规范")
    private String streetAddress;

    /**
     * 行业类目
     */
    private Integer unityCategoryId;

    /**
     * 银行卡正面
     */
    @NotNull(message = "不能为空")
    private String bankCardPhoto;

    /**
     * 法人户籍地址
     */
    @NotBlank(message = "不能为空")
    @Length(max = 128, message = "不符合规范")
    private String residenceAddress;

    /**
     * 法人身份证开始时间
     */
    @NotNull(message = "不能为空")
    private String legalPersonLicStt;

    /**
     * 法人身份证结束时间
     */
    @NotNull(message = "不能为空")
    private String legalPersonLicEnt;

    /**
     * 法人身份证是否长期有效 YES 是 NO 否
     */
    @NotNull(message = "不能为空")
    private String legalPersonLicEffect;

    /**
     * 结算人身份证开始时间
     */
    private String settlementPersonLicStt;

    /**
     * 结算人身份证结束时间
     */
    private String settlementPersonLicEnt;

    /**
     * 结算人身份证是否长期有效 YES 是 NO 否
     */
    private String settlementPersonLicEffect;

    /**
     * 非法人结算授权函 (法人和结算人不一致时必传)
     */
    private String authorizationPic;

    /**
     * 职业
     */
    private String professional = "D";

    /**
     * 客户细类
     */
    private String category = "210";

    /**
     * 商户id（代理商调用必传）
     */
    private Integer merchantId;


    /**
     * 分账接收方id(传了，走修改商户逻辑)
     */
    private String accountId;

    /**
     * 手持身份证(小微必传)
     */
    private String idcardHandPic;


    /**
     * 开源 开放平台侧不用传
     */
    private String sourceType;
}