/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhangling
 * @version FubeiAccountBalanceQueryRequest.java, v 0.1 2025-11-04 09:23 zhangling
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiAccountFixQueryRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -3783391037362108518L;
    /**
     * 付呗商户号,与account_id二选一，以商户级接入时无需填写
     */
    @NotBlank(message = "商户编号不能为空")
    private String merchantId;
    /**
     * 外部系统订单号
     */
    private String merchantOrderSn;
    /**
     * 分账订单号
     */
    private String orderNo;
    /**
     * 1-订单分账
     * 2-余额分账
     */
    @NotNull(message = "分账模式不能为空")
    private Integer shareMode;
}