/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhangling
 * @version FubeiAccountBalanceQueryRequest.java, v 0.1 2025-11-04 09:23 zhangling
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiAccountBalanceQueryRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -2428849968950534864L;

    /**
     * 付呗商户号,与account_id二选一，以商户级接入时无需填写
     */
    private String merchantId;
    /**
     * 分账接收方id,与merchant_id二选一，以商户级接入时，需要使用该字段进行查询时传入
     */
    private String accountId;
}