/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin.service;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.system.SystemUtil;
import com.fshows.fubei.maven.plugin.common.exception.BizException;
import com.fshows.fubei.maven.plugin.common.utils.MyFileUtil;
import com.fshows.fubei.maven.plugin.service.TemplateService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class ProjectService {
    public static void main(String[] args) {
        ProjectService.generatorCode("/Users/kiwi/work/code", "testssscore");
    }

    private static void generatorTemplateProject(String sourceProjectPath) {
        String project = FileUtil.mainName((String)sourceProjectPath);
        String destPath = FileUtil.getTmpDirPath() + TemplateService.OS_FILE_SEPARATOR + project;
        FileUtil.copy((String)sourceProjectPath, (String)destPath, (boolean)false);
        ArrayList files = Lists.newArrayList((Object[])FileUtil.ls((String)(destPath + TemplateService.OS_FILE_SEPARATOR + project)));
        for (File file : files) {
            if (StrUtil.equalsAny((CharSequence)file.getName(), (CharSequence[])new CharSequence[]{".idea", ".git", ".DS_Store"}) || StrUtil.equals((CharSequence)FileUtil.extName((File)file), (CharSequence)"iml")) {
                FileUtil.del((File)file);
            }
            if (!StrUtil.equals((CharSequence)file.getName(), (CharSequence)"src")) continue;
            ArrayList srcFiles = Lists.newArrayList((Object[])FileUtil.ls((String)file.getAbsolutePath()));
            for (File srcFile : srcFiles) {
                if (!StrUtil.equalsAny((CharSequence)srcFile.getName(), (CharSequence[])new CharSequence[]{".idea", ".git", ".DS_Store"}) && !StrUtil.equals((CharSequence)FileUtil.extName((File)srcFile), (CharSequence)"iml")) continue;
                FileUtil.del((File)srcFile);
            }
        }
        ZipUtil.zip((String)destPath, (String)(FileUtil.getParent((String)sourceProjectPath, (int)1) + TemplateService.OS_FILE_SEPARATOR + project + ".zip"));
        FileUtil.del((String)destPath);
    }

    public static String generatorCode(String projectRootPath, String project) {
        String tempDirName = RandomUtil.randomNumbers((int)5);
        String tempDir = projectRootPath + TemplateService.OS_FILE_SEPARATOR + tempDirName;
        String newProjectName = project + "-test";
        File zipFile = ProjectService.unzip("zip" + TemplateService.OS_FILE_SEPARATOR + "templateproject-test.zip", tempDir);
        System.out.println("\u66ff\u6362\u9879\u76ee\u5f00\u59cb\uff01");
        MyFileUtil.replaceFileAndDir(zipFile.getAbsolutePath(), "templateproject", project);
        FileUtil.move((File)FileUtil.newFile((String)(zipFile.getAbsoluteFile() + TemplateService.OS_FILE_SEPARATOR + newProjectName)), (File)FileUtil.newFile((String)FileUtil.getParent((String)zipFile.getAbsoluteFile().getAbsolutePath(), (int)1)), (boolean)false);
        FileUtil.del((String)tempDir);
        return projectRootPath + TemplateService.OS_FILE_SEPARATOR + newProjectName;
    }

    private static File unzip(String templateZipPath, String projectRootPath) {
        InputStream stream = new ClassPathResource(templateZipPath).getStream();
        File targetFile = new File(SystemUtil.getUserInfo().getHomeDir() + SystemUtil.getOsInfo().getFileSeparator() + templateZipPath);
        try {
            System.out.println(StrUtil.format((CharSequence)"\u89e3\u538b\u53c2\u6570\uff1atemplateZipPath = {}, projectRootPath = {}, targetFile = {}", (Object[])new Object[]{templateZipPath, projectRootPath, targetFile.getAbsolutePath()}));
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)targetFile);
        }
        catch (IOException e) {
            System.out.println("\u89e3\u538b\u51fa\u9519\uff1a" + ExceptionUtil.getMessage((Throwable)e));
            throw BizException.newInstance(ExceptionUtil.getMessage((Throwable)e));
        }
        File unzip = ZipUtil.unzip((String)targetFile.getAbsolutePath(), (String)projectRootPath);
        System.out.println("\u89e3\u538b\u5730\u5740\uff1aunzip = {}" + unzip.getAbsolutePath());
        if (targetFile.delete()) {
            // empty if block
        }
        return unzip;
    }
}

