/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.fubei.maven.plugin.common.utils.ConsoleUtil;
import com.google.common.collect.Lists;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="apolloConfig")
public class ApolloMojo
extends AbstractMojo {
    public static void main(String[] args) {
        ApolloMojo.generator("merchant.income.apply.query");
    }

    private static void generator(String bizName) {
        System.out.println("\n--------\u914d\u7f6e---------\n");
        String mq = StrUtil.format((CharSequence)"aliyun.mq.{}.tag\naliyun.mq.{}.prefix\naliyun.mq.{}.topicid\naliyun.mq.{}.gid", (Object[])new Object[]{bizName, bizName, bizName, bizName, bizName});
        String[] mqArr = mq.split("\n");
        String bizNameByUnderline = StrUtil.replace((CharSequence)ReUtil.getGroup1((String)"aliyun\\.mq\\.(.*)\\..*", (CharSequence)mqArr[0]), (CharSequence)".", (CharSequence)"_");
        Lists.newArrayList((Object[])new String[]{"dev", "test", "pre", "prod"}).forEach(env -> {
            System.out.println("--------" + env + "---------");
            System.out.println(StrUtil.format((CharSequence)"aliyun.mq.{}.gid=GID_{}_{}", (Object[])new Object[]{bizName, bizNameByUnderline, env}));
            System.out.println(StrUtil.format((CharSequence)"aliyun.mq.{}.topicid=Topic_{}_{}", (Object[])new Object[]{bizName, bizNameByUnderline, env}));
            System.out.println(StrUtil.format((CharSequence)"aliyun.mq.{}.tag=Tag_{}_{}", (Object[])new Object[]{bizName, bizNameByUnderline, env}));
            System.out.println(StrUtil.format((CharSequence)"aliyun.mq.{}.prefix=mq_{}_{}", (Object[])new Object[]{bizName, bizNameByUnderline, env}));
        });
        System.out.println("\n--------MQConfig---------\n");
        for (String s : mqArr) {
            System.out.println("\t@Value(\"${" + s + "}\")");
            System.out.println("\tprivate String " + StrUtil.toCamelCase((CharSequence)StrUtil.replace((CharSequence)StrUtil.removePrefix((CharSequence)s, (CharSequence)"aliyun.mq."), (CharSequence)".", (CharSequence)"_")) + ";");
        }
        System.out.println("\n--------\u679a\u4e3e---------\n");
        String bizNameByCamelCase = StrUtil.toCamelCase((CharSequence)bizNameByUnderline);
        System.out.println(bizNameByUnderline.toUpperCase() + "(\"\",\"" + bizNameByUnderline.toUpperCase() + "\");");
        System.out.println("\n--------producer---------\n");
        System.out.println(StrUtil.format((CharSequence)"    @Bean(name = \"{}Producer\", initMethod = \"start\", destroyMethod = \"shutdown\")\n    public IProducer {}Producer() {\n        return produceBeanMap.get(ProduceEnum.{});\n    }", (Object[])new Object[]{bizNameByCamelCase, bizNameByCamelCase, bizNameByUnderline.toUpperCase()}));
        System.out.println(StrUtil.format((CharSequence)"\n    private ProduceBean {}() {\n        ProduceBean produceBean = new ProduceBean();\n        produceBean.setProducer(createProducerBean(mqConfig.get{}Gid()));\n        produceBean.setTopicId(mqConfig.get{}Topicid());\n        produceBean.setTag(mqConfig.get{}Tag());\n        produceBean.setKeyPrefix(mqConfig.get{}Prefix());\n        return produceBean;\n    }", (Object[])new Object[]{bizNameByCamelCase, StrUtil.upperFirst((CharSequence)bizNameByCamelCase), StrUtil.upperFirst((CharSequence)bizNameByCamelCase), StrUtil.upperFirst((CharSequence)bizNameByCamelCase), StrUtil.upperFirst((CharSequence)bizNameByCamelCase)}));
        System.out.println(StrUtil.format((CharSequence)"\nproduceBeanMap.put(ProduceEnum.{}, new ProducerService({}()));", (Object[])new Object[]{bizNameByUnderline.toUpperCase(), bizNameByCamelCase}));
        System.out.println("\n--------consumer-------\n");
        System.out.println(StrUtil.format((CharSequence)"    @Bean(name = \"{}Consumer\", initMethod = \"start\", destroyMethod = \"shutdown\")\n    public ConsumerBean {}Consumer(@Autowired {}Listener {}Listener) {\n        return createConsumerBean(mqConfig.get{}Gid(), mqConfig.get{}Topicid(), mqConfig.get{}Tag(), DEFAULT_CONSUME_THREAD_NUM, {}Listener);\n    }", (Object[])new Object[]{bizNameByCamelCase, bizNameByCamelCase, StrUtil.upperFirst((CharSequence)bizNameByCamelCase), bizNameByCamelCase, StrUtil.upperFirst((CharSequence)bizNameByCamelCase), StrUtil.upperFirst((CharSequence)bizNameByCamelCase), StrUtil.upperFirst((CharSequence)bizNameByCamelCase), bizNameByCamelCase}));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String bizName = ConsoleUtil.getInput("\u8bf7\u8f93\u5165mq\u4e1a\u52a1\u540d\u79f0 eg. wx.pay", ".*");
        ApolloMojo.generator(bizName);
    }
}

