/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin.service;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fshows.fubei.maven.plugin.common.exception.BizException;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class GitlabService {
    private String gitlabBaseHost;
    private String token;

    public GitlabService(String gitlabBaseHost, String token) {
        this.gitlabBaseHost = gitlabBaseHost;
        this.token = token;
    }

    private Map<String, Object> createBaseParam() {
        HashMap param = Maps.newHashMap();
        param.put("private_token", this.token);
        return param;
    }

    public String getProjectIdByProjectName(String projectName) {
        Map<String, Object> param = this.createBaseParam();
        param.put("search", projectName);
        String responseStr = HttpUtil.get((String)(this.gitlabBaseHost + "projects"), param);
        JSONArray projectJsonArray = JSONUtil.parseArray((String)responseStr);
        if (projectJsonArray.isEmpty()) {
            throw BizException.newInstance("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u540d\u79f0");
        }
        if (projectJsonArray.size() > 1) {
            throw BizException.newInstance("\u9879\u76ee\u7ed3\u679c\u6709\u591a\u4e2a\uff0c\u8bf7\u8f93\u5165\u5b8c\u6574\u9879\u76ee\u540d\u79f0");
        }
        return ((JSONObject)projectJsonArray.get(0)).getStr((Object)"id");
    }

    public String getFileContent(String projectName, String filePath, String branch) {
        String projectId = this.getProjectIdByProjectName(projectName);
        Map<String, Object> param = this.createBaseParam();
        param.put("file_path", filePath);
        param.put("ref", branch);
        String responseStr = HttpUtil.get((String)StrUtil.format((CharSequence)(this.gitlabBaseHost + "/projects/{}/repository/files"), (Object[])new Object[]{projectId}), param);
        JSONObject responseByJson = JSONUtil.parseObj((String)responseStr);
        String codeContentByBase64 = responseByJson.getStr((Object)"content");
        if (StrUtil.isBlank((CharSequence)codeContentByBase64)) {
            throw BizException.newInstance("\u672a\u627e\u5230\u6587\u4ef6");
        }
        return Base64.decodeStr((CharSequence)codeContentByBase64);
    }
}

