/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.fubei.maven.plugin.common.exception.BizException;
import com.fshows.fubei.maven.plugin.service.GitlabService;
import com.fshows.fubei.maven.plugin.service.TemplateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMember;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.maven.plugin.logging.Log;

public class FacadeService {
    private static JavaProjectBuilder projectBuilder = new JavaProjectBuilder();
    private static String generatorType = "facade";

    public static void main(String[] args) {
        FacadeService.generator("com.fshows.lifecircle.fubeiappgw.service.api.LoginUserApi#login", "http://app-api-test.51youdian.com:9033/api/v3/", "iEFb2tmmdFS9RY1b_isJ", "feature/app_20200414_three", "com.fshows.fubei.maven.plugin", "/Users/kiwi/work/code/fubei-maven-plugin", null);
    }

    public static void generator(String refenceMethodStr, String gitlabBaseHost, String gitlabToken, String branchName, String generatorCodePackage, String projectRootPath, Log log) {
        List<Object> methodNameList = Lists.newArrayList((Object[])new String[]{refenceMethodStr});
        if (!refenceMethodStr.contains("#")) {
            FacadeInfo facadeInfo = new FacadeService().parseFacadeInfo(refenceMethodStr + "#test");
            methodNameList = FacadeService.findMethodNameList(facadeInfo, new GitlabService(gitlabBaseHost, gitlabToken), branchName).stream().map(it -> refenceMethodStr + "#" + it).collect(Collectors.toList());
        }
        for (String refenceMethod : methodNameList) {
            String[] refenceMethodArr = refenceMethod.split("#");
            String facade = refenceMethodArr[0];
            String method = refenceMethodArr[1];
            if (!facade.contains("facade")) {
                generatorType = "service";
            }
            String basePackage = facade.replace("com.fshows.lifecircle", generatorCodePackage);
            String generatorFilePath = projectRootPath + TemplateService.OS_FILE_SEPARATOR + StrUtil.join((CharSequence)TemplateService.OS_FILE_SEPARATOR, (Object[])new String[]{"src", "test", "java"}) + TemplateService.OS_FILE_SEPARATOR + StrUtil.replace((CharSequence)basePackage, (CharSequence)".", (CharSequence)TemplateService.OS_FILE_SEPARATOR) + TemplateService.OS_FILE_SEPARATOR + "Test" + StrUtil.upperFirst((CharSequence)method) + ".java";
            if (FileUtil.exist((String)generatorFilePath)) {
                System.out.println(FacadeService.trimAll(FacadeService.generatorRequestCode(refenceMethod, gitlabBaseHost, gitlabToken, branchName)));
                log.info((CharSequence)("\u6d4b\u8bd5\u7c7b[" + refenceMethod + "]\u5df2\u5b58\u5728\uff0crequest \u7c7b\u6253\u5370\u5e76\u81ea\u52a8\u590d\u5236\u5230\u7c98\u8d34\u677f\uff01"));
                continue;
            }
            try {
                FacadeService.generatorInit(refenceMethod, gitlabBaseHost, gitlabToken, branchName, generatorCodePackage, generatorFilePath);
            }
            catch (BizException e) {
                log.error((CharSequence)("\u6d4b\u8bd5\u7c7b[" + refenceMethod + "]\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5904\u7406\uff01" + e.getMsg()), (Throwable)e);
                continue;
            }
            log.info((CharSequence)("\u6d4b\u8bd5\u7c7b[" + refenceMethod + "]\u751f\u6210\u6210\u529f\uff01"));
        }
    }

    public static String generatorRequestCode(String refenceMethod, String gitlabBaseHost, String gitlabToken, String branchName) {
        FacadeInfo facadeInfo = new FacadeService().parseFacadeInfo(refenceMethod);
        GitlabService gitlabService = new GitlabService(gitlabBaseHost, gitlabToken);
        String fullyQualifiedName = FacadeService.getRequestFullyQualifiedName(facadeInfo, gitlabService, branchName);
        return TemplateService.render("RequestMap.ftl", (Map<String, Object>)Dict.create().set("paramList", FacadeService.getParamMapList(facadeInfo, gitlabService, fullyQualifiedName, branchName)));
    }

    public static void generatorInit(String refenceMethod, String gitlabBaseHost, String gitlabToken, String branchName, String generatorCodePackage, String generatorFilePath) {
        FacadeInfo facadeInfo = new FacadeService().parseFacadeInfo(refenceMethod);
        GitlabService gitlabService = new GitlabService(gitlabBaseHost, gitlabToken);
        String fullyQualifiedName = FacadeService.getRequestFullyQualifiedName(facadeInfo, gitlabService, branchName);
        List<Map<String, Object>> params = FacadeService.getParamMapList(facadeInfo, gitlabService, fullyQualifiedName, branchName);
        String packageStr = facadeInfo.getFacade().replace("com.fshows.lifecircle", generatorCodePackage);
        Dict content = Dict.create().set("dateTime", (Object)DateUtil.now()).set("testMethod", (Object)facadeInfo.getMethod()).set("requestClass", (Object)fullyQualifiedName).set("package", (Object)packageStr).set("facade", (Object)facadeInfo.getFacade()).set("project", (Object)ReUtil.getGroup1((String)"com.fshows.(\\w+).*", (CharSequence)packageStr)).set("api", (Object)facadeInfo.getGwApi()).set("methodComment", (Object)StrUtil.removeAllLineBreaks((CharSequence)facadeInfo.getMethodComment())).set("paramList", params);
        if (generatorType.equals("facade")) {
            content.set("testBase", (Object)"TestDubboBase");
        } else {
            content.set("testBase", (Object)"TestGwBase");
        }
        try {
            File testFile = FileUtil.newFile((String)generatorFilePath);
            FileUtil.writeString((String)new Formatter().formatSource(TemplateService.render("TestClass.ftl", (Map<String, Object>)content)), (File)testFile, (Charset)Charset.defaultCharset());
            File dataProviderFile = FileUtil.newFile((String)(generatorFilePath.replace("Test" + StrUtil.upperFirst((CharSequence)facadeInfo.getMethod()) + ".java", "dataprovider") + TemplateService.OS_FILE_SEPARATOR + "Test" + StrUtil.upperFirst((CharSequence)facadeInfo.getMethod()) + "DataProvider.java"));
            FileUtil.writeString((String)new Formatter().formatSource(TemplateService.render("DataProvider.ftl", (Map<String, Object>)content)), (File)dataProviderFile, (Charset)Charset.defaultCharset());
        }
        catch (FormatterException e) {
            throw BizException.newInstance(e.getMessage());
        }
    }

    private static List<Map<String, Object>> getParamMapList(FacadeInfo facadeInfo, GitlabService gitlabService, String fullyQualifiedName, String branchName) {
        ArrayList params = Lists.newArrayList();
        String codeStr = gitlabService.getFileContent(facadeInfo.getProjectName(), StrUtil.format((CharSequence)"{}-{}/src/main/java/{}.java", (Object[])new Object[]{facadeInfo.getProjectName(), generatorType, fullyQualifiedName.replaceAll("\\.", "/")}), branchName);
        JavaSource javaSource1 = projectBuilder.addSource((Reader)StrUtil.getReader((CharSequence)codeStr));
        List fields = ((JavaClass)javaSource1.getClasses().get(0)).getFields();
        for (JavaField field : fields) {
            if (field.getName().equals("serialVersionUID")) continue;
            HashMap param = Maps.newHashMap();
            if (StrUtil.isNotBlank((CharSequence)field.getComment())) {
                param.put("comment", StrUtil.removeAllLineBreaks((CharSequence)field.getComment()));
            }
            param.put("key", field.getName());
            param.put("value", "");
            params.add(param);
        }
        return params;
    }

    private static String getRequestFullyQualifiedName(FacadeInfo facadeInfo, GitlabService gitlabService, String branchName) {
        Optional<JavaAnnotation> apiAnno;
        String code = gitlabService.getFileContent(facadeInfo.getProjectName(), facadeInfo.getFacadeFilePath(), branchName);
        JavaSource javaSource = projectBuilder.addSource((Reader)StrUtil.getReader((CharSequence)code));
        JavaMethod javaMethod = ((JavaClass)javaSource.getClasses().get(0)).getMethods().stream().filter(it -> it.getName().equals(facadeInfo.getMethod())).findFirst().get();
        List annotations = javaMethod.getAnnotations();
        if (annotations != null && !annotations.isEmpty() && (apiAnno = annotations.stream().filter(it -> it.getType().getName().equals("com.fshows.fsframework.core.annotation.LifecircleApi")).findFirst()).isPresent()) {
            Optional<Object> name = Optional.ofNullable(apiAnno.get().getNamedParameter("name"));
            name.ifPresent(o -> facadeInfo.setGwApi(o.toString()));
        }
        facadeInfo.setMethodComment(javaMethod.getComment());
        List parameterTypes = javaMethod.getParameterTypes();
        return ((JavaType)parameterTypes.get(0)).getFullyQualifiedName();
    }

    private static List<String> findMethodNameList(FacadeInfo facadeInfo, GitlabService gitlabService, String branchName) {
        String code = gitlabService.getFileContent(facadeInfo.getProjectName(), facadeInfo.getFacadeFilePath(), branchName);
        JavaSource javaSource = projectBuilder.addSource((Reader)StrUtil.getReader((CharSequence)code));
        return ((JavaClass)javaSource.getClasses().get(0)).getMethods().stream().map(JavaMember::getName).collect(Collectors.toList());
    }

    private FacadeInfo parseFacadeInfo(String referenceMethod) {
        String projectName;
        String[] referenceArr = referenceMethod.split("#");
        if (referenceArr.length != 2) {
            throw BizException.newInstance("\u65b9\u6cd5\u5f15\u7528\u53c2\u6570\u4e0d\u89c4\u8303");
        }
        String facadeFacadeReference = referenceArr[0];
        String method = referenceArr[1];
        if (!facadeFacadeReference.contains("facade")) {
            generatorType = "service";
        }
        if (StrUtil.isBlank((CharSequence)(projectName = ReUtil.getGroup1((String)("com.fshows.(.*)." + generatorType), (CharSequence)facadeFacadeReference)))) {
            throw BizException.newInstance("\u65b9\u6cd5\u5f15\u7528\u53c2\u6570\u4e0d\u89c4\u8303");
        }
        FacadeInfo facadeInfo = new FacadeInfo();
        facadeInfo.setMethod(method);
        facadeInfo.setFacade(facadeFacadeReference);
        facadeInfo.setProjectName(projectName.replace(".", "-"));
        facadeInfo.setFacadeFilePath(StrUtil.format((CharSequence)"{}-{}/src/main/java/{}.java", (Object[])new Object[]{facadeInfo.getProjectName(), generatorType, facadeFacadeReference.replaceAll("\\.", "/")}));
        return facadeInfo;
    }

    public static String trimAll(String content) {
        List strList = StrUtil.splitTrim((CharSequence)content, (CharSequence)"\n");
        StrUtil.trim((String[])strList.toArray(new String[0]));
        return StrUtil.join((CharSequence)"\n", (Object[])new Object[]{strList});
    }

    class FacadeInfo {
        private String projectName;
        private String method;
        private String facadeFilePath;
        private String facade;
        private String gwApi;
        private String methodComment;

        FacadeInfo() {
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getFacadeFilePath() {
            return this.facadeFilePath;
        }

        public void setFacadeFilePath(String facadeFilePath) {
            this.facadeFilePath = facadeFilePath;
        }

        public String getFacade() {
            return this.facade;
        }

        public void setFacade(String facade) {
            this.facade = facade;
        }

        public String getGwApi() {
            return this.gwApi;
        }

        public void setGwApi(String gwApi) {
            this.gwApi = gwApi;
        }

        public String getMethodComment() {
            return this.methodComment;
        }

        public void setMethodComment(String methodComment) {
            this.methodComment = methodComment;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

