/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin.common.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ReUtil;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MyFileUtil {
    public static void replaceFileAndDir(String projectPath, String oldName, String newName) {
        File file = new File(projectPath);
        MyFileUtil.replaceFile(FileUtil.loopFiles((File)file), oldName, newName);
        MyFileUtil.renameDir(projectPath, oldName, newName);
    }

    private static void renameDir(String projectPath, String oldName, String newName) {
        List<File> currentDir = MyFileUtil.findCurrentDir(new File(projectPath));
        for (File file : currentDir) {
            MyFileUtil.renameDir(file.getAbsolutePath(), oldName, newName);
            String replace = ReUtil.replaceAll((CharSequence)file.getAbsolutePath(), (String)("(.*)" + oldName), (String)("$1" + newName));
            try {
                Files.move((File)file, (File)new File(replace));
            }
            catch (IOException iOException) {}
        }
        new File(projectPath).renameTo(new File(projectPath.replace(oldName, newName)));
    }

    private static List<File> findCurrentDir(File file) {
        return Arrays.asList((Object[])Objects.requireNonNull(file.listFiles(File::isDirectory)));
    }

    private static void replaceFile(List<File> files, String oldName, String newName) {
        for (File file : files) {
            String s = FileUtil.readString((File)file, (String)"utf-8");
            FileUtil.writeString((String)s.replace(oldName, newName), (File)file, (String)"utf-8");
        }
    }
}

