/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.system.SystemUtil;
import com.fshows.fubei.maven.plugin.service.TemplateService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ProjectService {
    public static void main(String[] args) {
        ProjectService.generatorCode("/Users/kiwi/work/code", "tradecore");
    }

    private static void generatorTemplateProject(String sourceProjectPath) {
        String project = FileUtil.mainName((String)sourceProjectPath);
        String destPath = FileUtil.getTmpDirPath() + TemplateService.OS_FILE_SEPARATOR + project;
        FileUtil.copy((String)sourceProjectPath, (String)destPath, (boolean)false);
        ArrayList files = Lists.newArrayList((Object[])FileUtil.ls((String)(destPath + TemplateService.OS_FILE_SEPARATOR + project)));
        for (File file : files) {
            if (StrUtil.equalsAny((CharSequence)file.getName(), (CharSequence[])new CharSequence[]{".idea", ".git", ".DS_Store"}) || StrUtil.equals((CharSequence)FileUtil.extName((File)file), (CharSequence)"iml")) {
                FileUtil.del((File)file);
            }
            if (!StrUtil.equals((CharSequence)file.getName(), (CharSequence)"src")) continue;
            ArrayList srcFiles = Lists.newArrayList((Object[])FileUtil.ls((String)file.getAbsolutePath()));
            for (File srcFile : srcFiles) {
                if (!StrUtil.equalsAny((CharSequence)srcFile.getName(), (CharSequence[])new CharSequence[]{".idea", ".git", ".DS_Store"}) && !StrUtil.equals((CharSequence)FileUtil.extName((File)srcFile), (CharSequence)"iml")) continue;
                FileUtil.del((File)srcFile);
            }
        }
        ZipUtil.zip((String)destPath, (String)(FileUtil.getParent((String)sourceProjectPath, (int)1) + TemplateService.OS_FILE_SEPARATOR + project + ".zip"));
        FileUtil.del((String)destPath);
    }

    public static String generatorCode(String projectRootPath, String project) {
        String tempDirName = RandomUtil.randomNumbers((int)5);
        String tempDir = projectRootPath + TemplateService.OS_FILE_SEPARATOR + tempDirName;
        String newProjectName = "fubei-test-" + project;
        File zipFile = ProjectService.unzip("zip" + TemplateService.OS_FILE_SEPARATOR + "fubei-test.zip", tempDir);
        List files = FileUtil.loopFiles((File)zipFile);
        for (File file : files) {
            FileUtil.writeString((String)FileUtil.readString((File)file, (Charset)Charset.defaultCharset()).replaceAll("fubei-test", newProjectName), (File)file, (Charset)Charset.defaultCharset());
        }
        FileUtil.rename((File)FileUtil.newFile((String)(zipFile.getAbsoluteFile() + TemplateService.OS_FILE_SEPARATOR + "fubei-test")), (String)newProjectName, (boolean)false, (boolean)false);
        FileUtil.move((File)FileUtil.newFile((String)(zipFile.getAbsoluteFile() + TemplateService.OS_FILE_SEPARATOR + newProjectName)), (File)FileUtil.newFile((String)FileUtil.getParent((String)zipFile.getAbsoluteFile().getAbsolutePath(), (int)1)), (boolean)false);
        FileUtil.del((String)tempDir);
        return projectRootPath + TemplateService.OS_FILE_SEPARATOR + project;
    }

    private static File unzip(String templateZipPath, String projectRootPath) {
        InputStream stream = ProjectService.class.getClassLoader().getResourceAsStream(templateZipPath);
        File targetFile = new File(SystemUtil.getUserInfo().getHomeDir() + SystemUtil.getOsInfo().getFileSeparator() + templateZipPath);
        try {
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File unzip = ZipUtil.unzip((String)targetFile.getAbsolutePath(), (String)projectRootPath);
        targetFile.delete();
        return unzip;
    }
}

