/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.maven.plugin.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.fubei.maven.plugin.common.exception.BizException;
import com.fshows.fubei.maven.plugin.service.GitlabService;
import com.fshows.fubei.maven.plugin.service.TemplateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FacadeService {
    private static JavaProjectBuilder projectBuilder = new JavaProjectBuilder();

    public static void main(String[] args) throws FormatterException {
        FacadeService.generator("com.fshows.lifecircle.basecore.facade.ActivityRateFacade#getActivityRate", "http://app-api-test.51youdian.com:9033/api/v3/", "iEFb2tmmdFS9RY1b_isJ", "master", "com.fshows.fubei.maven.plugin.service", "/Users/kiwi/work/code/fubei-maven-plugin");
    }

    public static void generator(String refenceMethod, String gitlabBaseHost, String gitlabToken, String branchName, String generatorCodePackage, String projectRootPath) {
        String[] refenceMethodArr = refenceMethod.split("#");
        String facade = refenceMethodArr[0];
        String method = refenceMethodArr[1];
        String basePackage = facade.replace("com.fshows.lifecircle", generatorCodePackage);
        String generatorFilePath = projectRootPath + TemplateService.OS_FILE_SEPARATOR + StrUtil.join((CharSequence)TemplateService.OS_FILE_SEPARATOR, (Object[])new String[]{"src", "test", "java"}) + TemplateService.OS_FILE_SEPARATOR + basePackage.replaceAll("\\.", TemplateService.OS_FILE_SEPARATOR) + TemplateService.OS_FILE_SEPARATOR + "Test" + StrUtil.upperFirst((CharSequence)method) + ".java";
        if (FileUtil.exist((String)generatorFilePath)) {
            System.out.println(FacadeService.generatorRequestCode(refenceMethod, gitlabBaseHost, gitlabToken, branchName));
        } else {
            File file = FileUtil.newFile((String)generatorFilePath);
            FileUtil.writeString((String)FacadeService.generatorInit(refenceMethod, gitlabBaseHost, gitlabToken, branchName, generatorCodePackage), (File)file, (Charset)Charset.defaultCharset());
            System.out.println("\u751f\u6210\u6210\u529f\uff01");
        }
    }

    public static String generatorRequestCode(String refenceMethod, String gitlabBaseHost, String gitlabToken, String branchName) {
        FacadeInfo facadeInfo = new FacadeService().parseFacadeInfo(refenceMethod);
        GitlabService gitlabService = new GitlabService(gitlabBaseHost, gitlabToken);
        String fullyQualifiedName = FacadeService.getRequestFullyQualifiedName(facadeInfo, gitlabService, branchName);
        return TemplateService.render("RequestMap.ftl", (Map<String, Object>)Dict.create().set("paramList", FacadeService.getParamMapList(facadeInfo, gitlabService, fullyQualifiedName, branchName)));
    }

    public static String generatorInit(String refenceMethod, String gitlabBaseHost, String gitlabToken, String branchName, String generatorCodePackage) {
        FacadeInfo facadeInfo = new FacadeService().parseFacadeInfo(refenceMethod);
        GitlabService gitlabService = new GitlabService(gitlabBaseHost, gitlabToken);
        String fullyQualifiedName = FacadeService.getRequestFullyQualifiedName(facadeInfo, gitlabService, branchName);
        List<Map<String, Object>> params = FacadeService.getParamMapList(facadeInfo, gitlabService, fullyQualifiedName, branchName);
        Dict content = Dict.create().set("dateTime", (Object)DateUtil.now()).set("testMethod", (Object)facadeInfo.getMethod()).set("requestClass", (Object)fullyQualifiedName).set("package", (Object)facadeInfo.getFacade().replace("com.fshows.lifecircle", generatorCodePackage)).set("facade", (Object)facadeInfo.getFacade()).set("paramList", params);
        try {
            return new Formatter().formatSource(TemplateService.render("TestClass.ftl", (Map<String, Object>)content));
        }
        catch (FormatterException e) {
            throw BizException.newInstance(e.getMessage());
        }
    }

    private static String getParamByMap(FacadeInfo facadeInfo, GitlabService gitlabService, String fullyQualifiedName, String branchName) {
        String codeStr = gitlabService.getFileContent(facadeInfo.getProjectName(), StrUtil.format((CharSequence)"{}-facade/src/main/java/{}.java", (Object[])new Object[]{facadeInfo.getProjectName(), fullyQualifiedName.replaceAll("\\.", "/")}), branchName);
        JavaSource javaSource1 = projectBuilder.addSource((Reader)StrUtil.getReader((CharSequence)codeStr));
        List fields = ((JavaClass)javaSource1.getClasses().get(0)).getFields();
        StringBuilder sb = new StringBuilder("Map<String, Object> params = new HashMap<>();\n");
        for (JavaField field : fields) {
            if (field.getName().equals("serialVersionUID")) continue;
            if (StrUtil.isNotBlank((CharSequence)field.getComment())) {
                sb.append(StrUtil.format((CharSequence)"\t\t//\t{}\n", (Object[])new Object[]{field.getComment()}));
            }
            sb.append(StrUtil.format((CharSequence)"\t\tparams.put(\"{}\", {});\n", (Object[])new Object[]{field.getName(), "\"\""}));
        }
        return sb.toString();
    }

    private static List<Map<String, Object>> getParamMapList(FacadeInfo facadeInfo, GitlabService gitlabService, String fullyQualifiedName, String branchName) {
        ArrayList params = Lists.newArrayList();
        String codeStr = gitlabService.getFileContent(facadeInfo.getProjectName(), StrUtil.format((CharSequence)"{}-facade/src/main/java/{}.java", (Object[])new Object[]{facadeInfo.getProjectName(), fullyQualifiedName.replaceAll("\\.", "/")}), branchName);
        JavaSource javaSource1 = projectBuilder.addSource((Reader)StrUtil.getReader((CharSequence)codeStr));
        List fields = ((JavaClass)javaSource1.getClasses().get(0)).getFields();
        for (JavaField field : fields) {
            if (field.getName().equals("serialVersionUID")) continue;
            HashMap param = Maps.newHashMap();
            if (StrUtil.isNotBlank((CharSequence)field.getComment())) {
                param.put("comment", field.getComment());
            }
            param.put("key", field.getName());
            param.put("value", "");
            params.add(param);
        }
        return params;
    }

    private static String getRequestFullyQualifiedName(FacadeInfo facadeInfo, GitlabService gitlabService, String branchName) {
        String code = gitlabService.getFileContent(facadeInfo.getProjectName(), facadeInfo.getFacadeFilePath(), branchName);
        JavaSource javaSource = projectBuilder.addSource((Reader)StrUtil.getReader((CharSequence)code));
        List parameterTypes = ((JavaClass)javaSource.getClasses().get(0)).getMethods().stream().filter(it -> it.getName().equals(facadeInfo.getMethod())).findFirst().get().getParameterTypes();
        return ((JavaType)parameterTypes.get(0)).getFullyQualifiedName();
    }

    private FacadeInfo parseFacadeInfo(String referenceMethod) {
        String[] referenceArr = referenceMethod.split("#");
        if (referenceArr.length != 2) {
            throw BizException.newInstance("\u65b9\u6cd5\u5f15\u7528\u53c2\u6570\u4e0d\u89c4\u8303");
        }
        String facadeFacadeReference = referenceArr[0];
        String method = referenceArr[1];
        String projectName = ReUtil.getGroup1((String)"com.fshows.(.*).facade", (CharSequence)facadeFacadeReference);
        if (StrUtil.isBlank((CharSequence)projectName)) {
            throw BizException.newInstance("\u65b9\u6cd5\u5f15\u7528\u53c2\u6570\u4e0d\u89c4\u8303");
        }
        FacadeInfo facadeInfo = new FacadeInfo();
        facadeInfo.setMethod(method);
        facadeInfo.setFacade(facadeFacadeReference);
        facadeInfo.setProjectName(projectName.replace(".", "-"));
        facadeInfo.setFacadeFilePath(StrUtil.format((CharSequence)"{}-facade/src/main/java/{}.java", (Object[])new Object[]{facadeInfo.getProjectName(), facadeFacadeReference.replaceAll("\\.", "/")}));
        return facadeInfo;
    }

    class FacadeInfo {
        private String projectName;
        private String method;
        private String facadeFilePath;
        private String facade;

        FacadeInfo() {
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getFacadeFilePath() {
            return this.facadeFilePath;
        }

        public void setFacadeFilePath(String facadeFilePath) {
            this.facadeFilePath = facadeFilePath;
        }

        public String getFacade() {
            return this.facade;
        }

        public void setFacade(String facade) {
            this.facade = facade;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

