/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.tempalte.single;

import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.client.component.signer.RsaSignHandlerImpl;
import com.fshows.sdk.core.client.tempalte.single.apienum.SingleApiDefinitionEnum;
import com.fshows.sdk.core.client.tempalte.single.request.SingleBaseRequest;
import com.fshows.sdk.core.client.tempalte.single.response.SingleBaseResponse;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.RequestParamUtils;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * 嵌套参数客户端模版
 * @author liluqing
 * @version NestTemplateApiClinet.java, v 0.1 2023-12-12 15:40
 */
@Slf4j
public class SingleTemplateApiClinet extends AbstractApiClient<SingleBaseRequest, SingleBaseResponse, SingleApiDefinitionEnum> {

     /**
      * 加签验签处理器
      */
    protected IApiSignHandler iApiSignHandler = new RsaSignHandlerImpl();

     /**
      * 序列化处理器
      */
     protected ISerializableHandler paramSerializable = new JsonSerializableHandler();

     /**
      * 请求执行器
      */
     protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public SingleTemplateApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    @Override
    public SingleBaseResponse execute(SingleBaseRequest request, SingleApiDefinitionEnum apiDefinition) throws FsApiException {
        return super.doExecute(request, apiDefinition);
    }

    @Override
    public SingleBaseResponse execute(SingleBaseRequest request, SingleApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return super.doExecute(request, apiDefinition, configModel);
    }

    /**
      * 构建请求参数
      *
      * @param request
      * @param context
      * @return
      */
    @Override
    protected ApiRequestModel buildApiRequestModel(SingleBaseRequest request, DefaultRequestContext context) {
        // todo: 一般来说该方法需要完成以下事项
        // 1. 设置网关地址  2. 请求参数填充  3. 请求加签  4. 请求参数序列化

        // sdk客户端配置
        DefaultClientConfigModel defaultClientConfigModel = context.getApiClientConfig();

        ApiRequestModel apiRequestModel = new ApiRequestModel();
        // 设置网关地址
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        // 请求加签处理
        apiRequestModel.setParamMap(RequestParamUtils.toMapObj(request, apiClientConfig.isHump(),true));
        apiRequestModel.setRequestSign(iApiSignHandler.sign(apiRequestModel, context));

        // 补充参数构建实际的请求入参
        SingleBaseRequest singleBaseRequest = new SingleBaseRequest();
        singleBaseRequest.setMchntCd(defaultClientConfigModel.getAppId());
        singleBaseRequest.setSignature(apiRequestModel.getRequestSign());
        //singleBaseRequest.setData(request);
        apiRequestModel.setRequest(singleBaseRequest);

        // 参数序列化
        String requestBody = paramSerializable.serializeObject(apiRequestModel, context);
        apiRequestModel.setRequestBody(requestBody);
        return apiRequestModel;
    }

     /**
      * 处理客户端信息
      *
      * @return
      */
    @Override
    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("fuiou-sdk");
        clientInfoModel.setClientCode("富友分账");
        return clientInfoModel;
    }

     @Override
     protected SingleBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
         // todo: 该方法需要完成以下内容
         // 1.响应结果反序列化    2. 返回结果验签
        // 客户端配置
        DefaultClientConfigModel clientConfigModel = requestContext.getApiClientConfig();
        apiResponseModel.setResponse(paramSerializable.deserializationResponse(apiResponseModel, apiRequestModel, requestContext));
        // 是否验签
        Boolean verifySign = iApiSignHandler.verifySign(apiResponseModel, apiRequestModel,  requestContext);
        // 如果需要验签
        if (clientConfigModel.isVrifySignResponse() && !Boolean.TRUE.equals(verifySign)) {
            throw new FsApiException("验签失败");
        }
        return (SingleBaseResponse) apiResponseModel.getResponse();
     }

     @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }
}