/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.model;

import lombok.Data;

/**
 * 客户端信息
 *
 * @author liluqing
 * @version ClientInfoModel.java, v 0.1 2023-12-11 18:53
 */
@Data
public class ClientInfoModel {

    /**
     * sdk客户端标识,例如：leshuapay-sdk,fuiou-sdk 等
     */
    private String clientCode;

    /**
     * 客户端名称,例如：乐刷sdk,富友sdk 等
     */
    private String clientName;

    /**
     * 客户端描述信息
     */
    private String clientDesc;

    /**
     * 获取客户端描述，用于日志打印
     *
     * @return
     */
    public String getClientDesc() {
        return "【"+clientCode+"】" + clientName;
    }
}