/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.core.client.component.signer;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.SignerUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaSignHandlerImpl
implements IApiSignHandler {
    private static final Logger log = LoggerFactory.getLogger(RsaSignHandlerImpl.class);

    @Override
    public String sign(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws FsApiException {
        String waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            String privateKey = apiClientConfig.getFubeiPrivateKey();
            Map<String, Object> data = apiRequestModel.getParamMap();
            waitSignStr = SignerUtil.getWaitSignStr(data, requestContext.getNoNeedSignWords(), requestContext.getApiClientConfig().isSingIgnoreNull());
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)privateKey), null);
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", e, requestContext.getClientInfoModel().getClientDesc(), apiRequestModel, waitSignStr);
            throw new FsApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    @Override
    public Boolean verifySign(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws FsApiException {
        String waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            String publicKey = apiClientConfig.getPayCompanyPublicKey();
            Map<String, Object> data = apiResponseModel.getResponseMap();
            waitSignStr = SignerUtil.getWaitSignStr(data, requestContext.getNoNeedSignWords(), requestContext.getApiClientConfig().isSingIgnoreNull());
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), null, SecureUtil.decode((String)publicKey));
            return sign.verify(waitSignStr.getBytes(apiClientConfig.getCharset()), Base64.decode((CharSequence)apiResponseModel.getResponseSign()));
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u54cd\u5e94\u9a8c\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", e, requestContext.getClientInfoModel().getClientDesc(), apiResponseModel, waitSignStr);
            throw new FsApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }
}

