/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.sdk.core.exception;

import com.fshows.sdk.core.enums.base.FsApiExceptionEnum;

/**
 * @author liluqing
 * @version FsApiException.java, v 0.1 2022-03-02 5:03 PM liluqing
 */
public class FsApiException extends RuntimeException {

    public FsApiException() {
    }

    public FsApiException(String message) {
        super(message);
    }

    public FsApiException(String message, Throwable ex) {
        super(message, ex);
    }

    /**
     * 具体异常码
     */
    protected String code;

    /**
     * 异常信息
     */
    protected String msg;

    /**
     * 业务异常码
     */
    protected String bizCode;

    /**
     * 业务异常信息
     */
    protected String bizMsg;

    public FsApiException(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private FsApiException(String code, String msg, String bizCode, String bizMsg) {
        this.code = code;
        this.msg = msg;
        this.bizCode = bizCode;
        this.bizMsg = bizMsg;
    }

    /**
     * 创建业务异常
     *
     * @param bizCode
     * @param bizMsg
     * @return
     */
    public FsApiException newBizInstance(String bizCode, String bizMsg) {
        return new FsApiException(code, bizMsg, bizCode, bizMsg);
    }

    /**
     * 创建业务异常
     *
     * @param bizMsg
     * @return
     */
    public FsApiException newBizInstance(String bizMsg) {
        return new FsApiException(code, bizMsg, code, bizMsg);
    }

    /**
     * 异常构造器
     *
     * @param errorEnums
     */
    private FsApiException(FsApiExceptionEnum errorEnums) {
        this(errorEnums.getCode(), errorEnums.getMsg());
    }

    /**
     * 未知异常
     */
    public static final FsApiException UNKNOW_ERROR = new FsApiException(FsApiExceptionEnum.UNKNOW_ERROR);
    /**
     * 业务异常
     */
    public static final FsApiException BIZ_RESPONSE_ERROR = new FsApiException(FsApiExceptionEnum.BIZ_RESPONSE_ERROR);
    /**
     * 接口返回值为空
     */
    public static final FsApiException SDK_RESPONSE_NULL = new FsApiException(FsApiExceptionEnum.SDK_RESPONSE_NULL);

}
