/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.component.serializable;

import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.util.RequestParamUtils;

import java.util.Map;

/**
 * 简单结构的xml序列化处理，只能如理如下格式只有一层节点的简单xml结构
 *          <xml>
 *              <order_sn>20132718192323</order_sn>
 *              <order_price>0.01</order_price>
 *          </xml>
 *
 * @author liluqing
 * @version SimpleXmlSerializable.java, v 0.1 2023-12-13 16:24
 */
public class SimpleXmlSerializableHandler implements ISerializableHandler {

    @Override
    public String serializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        Map<String, String> requstMap = RequestParamUtils.toMap(apiRequestModel.getRequest());
        return RequestParamUtils.generateXml(requstMap);
    }

    @Override
    public IResponseDefinition deserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        IApiDefinition apiDefinition = requestContext.getIApiDefinition();
        // 将xml报文转化为中间参数map
        String xml = "<?xml version=\"1.0\" encoding=\"GBK\" standalone=\"yes\"?>" + apiResponseModel.getResponseBody();
        Map<String, Object> resMap = RequestParamUtils.getMapFromXML(xml);
        apiResponseModel.setResponseMap(resMap);
        // 将中间参数map转化为响应结果实体类
        IResponseDefinition response = RequestParamUtils.getObjectFromMap(apiResponseModel.getResponseMap(), apiDefinition.getResponseClass());
        apiResponseModel.setResponse(response);
        return response;
    }
}