/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.component.http;

import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.util.FsHttpUtil;

import java.io.IOException;

/**
 * post请求执行器
 *
 * @author liluqing
 * @version PostHttpRequestHandler.java, v 0.1 2023-12-13 17:19
 */
public class PostHttpRequestHandler implements IHttpRequestHandler {

    @Override
    public ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String fsHttpResult = FsHttpUtil.postString(
                    apiRequestModel.getApiURL(),
                    apiRequestModel.getRequestBody(),
                    apiClientConfig.getCharset(),
                    apiRequestModel.getContentType(),
                    apiClientConfig.getConnectionTimeout(),
                    apiClientConfig.getReadTimeout(),
                    apiRequestModel.getHeadMap());
        // 封装请求结果
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(fsHttpResult);
        return responseModel;
    }
}