/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.sdk.core.client.component.http;

import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.util.FsHttpUtil;

import java.io.IOException;

/**
 * Http协议Get类型请求处理器
 *
 * @author weikunpeng
 * @version GetHttpRequestHandler.java, v 0.1 2024-10-08 17:26 weikunpeng
 */
public class GetHttpRequestHandler implements IHttpRequestHandler {
    @Override
    public ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String fsHttpResult = FsHttpUtil.get(
                apiRequestModel.getApiURL(),
                apiRequestModel.getRequestForm(),
                apiRequestModel.getContentType(),
                apiClientConfig.getCharset(),
                apiClientConfig.getConnectionTimeout(),
                apiClientConfig.getReadTimeout(),
                apiRequestModel.getHeadMap());
        // 封装请求结果
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(fsHttpResult);
        return responseModel;
    }
}