/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.handler;

import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;

/**
 * 参数序列化
 *
 * @author liluqing
 * @version IParamSerializable.java, v 0.1 2023-12-11 19:55
 */
public interface ISerializableHandler {


    /**
     * 请求参数序列化
     *
     * @param apiRequestModel
     * @param requestContext
     * @return
     */
    String serializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext);

    /**
     * 响应参数反序列化
     *
     * @param apiRequestModel
     * @param requestContext
     * @return
     */
    IResponseDefinition deserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext);
}