/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base;

import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.exception.FsApiException;

/**
 * 威富通API客户端
 *
 * @author liluqing
 * @version ISwiftApiClient.java, v 0.1 2022-03-02 11:17
 */
public interface IApiClient<REQ extends IRequestDefinition, RES extends IResponseDefinition, API extends IApiDefinition> {


    /**
     * 调用接口
     * @param request
     * @param apiDefinition
     * @return {@link RES}
     * @throws FsApiException
     */
    RES execute(REQ request, API apiDefinition) throws FsApiException;


    /**
     * 调用接口(带商户配置参数)
     * @param request
     * @param apiDefinition
     * @param configModel
     * @return {@link RES}
     * @throws FsApiException
     */
    RES execute(REQ request, API apiDefinition, DefaultClientConfigModel configModel) throws FsApiException;
}