package com.fshows.sdk.core.client.tempalte.single.apienum;


import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 富友富管家相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum SingleApiDefinitionEnum implements IApiDefinition {

    XXXX_API("", "/order/query", "1.0", null, null);
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    SingleApiDefinitionEnum(String name,
                            String apiSubURI,
                            String version,
                            Class requestClass,
                            Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}